% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modMApop.R
\name{modMApop}
\alias{modMApop}
\title{Model-Assisted module - Generate population data for MA module.}
\usage{
modMApop(
  popType = "VOL",
  popTabs = popTables(),
  popTabIDs = popTableIDs(),
  popFilter = popFilters(),
  pltassgn = NULL,
  pltassgnid = "PLT_CN",
  dsn = NULL,
  pjoinid = "CN",
  areawt = "CONDPROP_UNADJ",
  adjplot = TRUE,
  unitvar = NULL,
  unitarea = NULL,
  areavar = "ACRES",
  unitzonal = NULL,
  prednames = NULL,
  predfac = NULL,
  standardize = TRUE,
  returndata = TRUE,
  savedata = FALSE,
  saveobj = FALSE,
  objnm = "MApopdat",
  unit_opts = NULL,
  savedata_opts = NULL,
  MAdata = NULL,
  pltdat = NULL,
  auxdat = NULL,
  gui = FALSE,
  ...
)
}
\arguments{
\item{popType}{String. Type of evaluation(s) to include in population data.
Note: currently only c('CURR', 'VOL', 'LULC') are available. See details
below for descriptions of each.}

\item{popTabs}{List of population tables the user would like returned.
See help(popTables) for a list of options.}

\item{popTabIDs}{List of unique IDs corresponding to the population tables
that the user has requested. See help(popTableIDs) for a list of
options.}

\item{popFilter}{List of population filters. See help(popFilters) for a 
list of options.}

\item{pltassgn}{DF/DT, Optional. R object, sf R object, comma-delimited
file(.csv), layer or spatial layer in dsn, or shapefile(.shp). Plot-level
assignment of estimation unit and/or strata, with one record for each plot.}

\item{pltassgnid}{String.}

\item{dsn}{String. Name of database where tree, cond, and plot-level tables
reside.  The dsn varies by driver. See gdal OGR vector formats
(https://www.gdal.org/ogr_formats.html).}

\item{pjoinid}{String. Join variable in plot to match pltassgnid. Does not
need to be uniqueid. If using most current XY coordinates for plot
assignments, use identifier for plot (e.g., PLOT_ID).}

\item{areawt}{String. Name of variable for summarizing area weights (e.g.,
CONDPROP_UNADJ).}

\item{adjplot}{Logical. If TRUE, adjusts for nonresponse at plot-level.}

\item{unitvar}{String. Name of the estimation unit variable in unitarea and
cond or pltassgn data frame with estimation unit assignment for each plot
(e.g., 'ESTN_UNIT'). Optional if only one estimation unit.}

\item{unitarea}{Numeric or DF. Total area by estimation unit. If only 1
estimation unit, include number of total acreage for the area of interest or
a data frame with area and estimation unit. If more than one estimation
unit, provide a data frame of total area by estimation unit, including
unitvar and areavar.}

\item{areavar}{String. Name of area variable in unitarea. Default="ACRES".}

\item{unitzonal}{DF/DT. Table with zonal auxiliary information by estimation
unit. For continuous data, means by estimation unit; for categorical data,
proportion of class by estimation unit.}

\item{prednames}{String vector. Name(s) of predictor variables to include in
model.}

\item{predfac}{String vector. Name(s) of prednames that are factors (i.e.,
categorical). Names will change in output depending on number of categories.}

\item{standardize}{Logical. If TRUE, predictors are standardized.}

\item{returndata}{Logical. If TRUE, returns data objects.}

\item{savedata}{Logical. If TRUE, saves table(s) to outfolder.}

\item{saveobj}{Logical. If TRUE, saves returned list object to outfolder.}

\item{objnm}{String. Name of *.rds object.}

\item{unit_opts}{List. See help(unit_options()) for a list of options.}

\item{savedata_opts}{List. See help(savedata_options()) for a list
of options. Only used when savedata = TRUE.}

\item{MAdata}{List. Data output from FIESTA::MAdata().}

\item{pltdat}{R List object. Output data list components from
FIESTA::spGetPlots().}

\item{auxdat}{List. Auxiliary data output from FIESTA::spGetAuxiliary().}

\item{gui}{Logical. If gui, user is prompted for parameters.}

\item{...}{For extendibility.}
}
\value{
A list with population data for Green-Book estimates.

\item{condx}{ Data frame. Condition-level data including plot-level
assignment of estimation unit and stratum (if strata=TRUE) and adjusted
condition proportion. } 
\item{pltcondx}{ Data frame. Condition-level data, merged with plot data. } 
\item{cuniqueid}{ String. Unique identifier of plot in condx and pltcondx. } 
\item{condid}{ String. Unique identifier of condition in condx and pltcondx. } 
\item{treex}{ Data frame. If esttype='TREE', tree-level data, including 
sample adjustment factor. }
\item{tuniqueid}{ String. If esttype='TREE', unique identifier of plot in
treex. } 
\item{ACI.filter}{ String. If ACI=FALSE, ACI.filter="COND_STATUS_CD
== 1" . } 
\item{unitarea}{ String. Returned table of area by estimation unit. } 
\item{unitvar}{ String. Variable name for estimation unit. }
\item{expcondtab}{ String. If ACI=FALSE, ACI.filter="COND_STATUS_CD == 1". } 
\item{plotsampcnt}{ Data frame. Number of plots by PLOT_STATUS_CD. } 
\item{condsampcnt}{ Data frame. Number of conditions by COND_STATUS_CD. } 
\item{states}{ String. State names in dataset. } 
\item{invyrs}{ String. Range of inventory years in dataset. }

\tabular{lll}{ \tab \bold{Variable} \tab \bold{Description}\cr 
\tab unitvar \tab estimation unit \cr 
\tab n.total \tab number of plots for estimation unit \cr 
\tab CONDPROP_UNADJ_SUM \tab summed condition proportion by strata and 
estimation unit \cr 
\tab CONDPROP_ADJFAC \tab adjusted condition proportion by strata after 
nonsampled plots removed \cr 
\tab AREA_USED \tab total area of estimation unit \cr 
\tab expfac \tab strata-level expansion factor after nonsampled plots and 
conditions removed (AREA_USED/n.strata) \cr 
\tab EXPNS \tab strata-level area expansions (expfac * strwt)\cr }

Table(s) are also written to outfolder.
}
\description{
Generates population data for generating model-assisted estimation.  Plots
that are totally nonsampled are excluded from estimation dataset. Next, an
adjustment factor is calculated by strata (if MAmethod="PS") or by
estimation unit to adjust for nonsampled (nonresponse) conditions that have
proportion less than 1. Attributes adjusted to a per-acre value are summed
by plot, divided by the adjustment factor, and averaged by stratum and/or
estimation unit. Note: population data must be generated by MA method.
}
\details{
If variables are NULL, then it will prompt user to input variables.

Necessary variables:\cr 
\tabular{llll}{ 
\tab \bold{Data} \tab \bold{Variable} \tab \bold{Description}\cr 
\tab tree \tab tuniqueid 
\tab Unique identifier for each plot, to link to pltassgn (e.g. PLT_CN).\cr 
\tab \tab CONDID \tab Unique identifier of each condition on plot, to link to
cond.  Set CONDID=1, if only 1 condition per plot.\cr 
\tab \tab TPA_UNADJ \tab Number of trees per acre each sample tree represents 
(e.g. DESIGNCD=1: TPA_UNADJ=6.018046 for trees on subplot; 74.965282 for 
trees on microplot).\cr 
\tab cond \tab cuniqueid \tab Unique identifier for each plot, to link to 
pltassgn (e.g. PLT_CN).\cr 
\tab \tab CONDID \tab Unique identifier of each condition on plot. Set 
CONDID=1, if only 1 condition per plot.\cr 
\tab \tab CONDPROP_UNADJ \tab Unadjusted proportion of condition on
each plot.  Set CONDPROP_UNADJ=1, if only 1 condition per plot.\cr 
\tab \tab COND_STATUS_CD \tab Status of each forested condition on plot 
(i.e. accessible forest, nonforest, water, etc.)\cr 
\tab \tab NF_COND_STATUS_CD \tab If ACI=TRUE. Status of each nonforest 
condition on plot (i.e. accessible nonforest, nonsampled nonforest)\cr 
\tab \tab SITECLCD \tab If landarea=TIMBERLAND. Measure of site 
productivity.\cr 
\tab \tab RESERVCD \tab If landarea=TIMBERLAND. Reserved status.\cr 
\tab \tab SUBPROP_UNADJ \tab Unadjusted proportion of subplot conditions 
on each plot. Set SUBPROP_UNADJ=1, if only 1 condition per subplot.\cr 
\tab \tab MICRPROP_UNADJ \tab If microplot tree attributes. Unadjusted 
proportion of microplot conditions on each plot. Set MICRPROP_UNADJ=1, 
if only 1 condition per microplot.\cr 
\tab \tab MACRPROP_UNADJ \tab If macroplot tree attributes. Unadjusted 
proportion of macroplot conditions on each plot. Set MACRPROP_UNADJ=1, 
if only 1 condition per macroplot.\cr \tab pltassgn \tab puniqueid 
\tab Unique identifier for each plot, to link to cond (e.g. CN).\cr
\tab \tab STATECD \tab Identifies state each plot is located in.\cr 
\tab \tab INVYR \tab Identifies inventory year of each plot.\cr 
\tab \tab PLOT_STATUS_CD \tab Status of each plot (i.e. sampled, 
nonsampled). If not included, all plots are assumed as sampled.\cr }

For available reference tables: sort(unique(FIESTAutils::ref_codes$VARIABLE)) \cr
}
\note{
ADJUSTMENT FACTOR:\cr The adjustment factor is necessary to account for
nonsampled conditions. It is calculated for each estimation unit by strata.
by summing the unadjusted proportions of the subplot, microplot, and
macroplot (i.e. *PROP_UNADJ) and dividing by the number of plots in the
strata/estimation unit).

An adjustment factor is determined for each tree based on the size of the
plot it was measured on. This is identified using TPA_UNADJ as follows:

\tabular{llr}{ \tab \bold{PLOT SIZE} \tab \bold{TPA_UNADJ} \cr 
\tab SUBPLOT \tab 6.018046 \cr 
\tab MICROPLOT \tab 74.965282 \cr 
\tab MACROPLOT \tab 0.999188 \cr }

If ACI=FALSE, only nonsampled forest conditions are accounted for in the
adjustment factor. \cr 
If ACI=TRUE, the nonsampled nonforest conditions are
removed as well and accounted for in adjustment factor.  This is if you are
interested in estimates for all lands or nonforest lands in the
All-Condition-Inventory.

unitcombine:\cr If TRUE and less than 2 plots in any one estimation unit,
all estimation units with 10 or less plots are combined. The current method
for combining is to group the estimation unit with less than 10 plots with
the estimation unit following in consecutive order (numeric or
alphabetical), restrained by survey unit (UNITCD) if included in dataset,
and continuing until the number of plots equals 10. If there are no
estimation units following in order, it is combined with the estimation unit
previous in order.

stratcombine:\cr If TRUE and less than 2 plots in any one strata class
within an estimation unit, all strata classes with 2 or less plots are
combined. The current method for combining is to group the strata with less
than 2 plots with the strata class following in consecutive order (numeric
or alphabetical), restrained by estimation unit (if unitcombine=FALSE), and
continuing until the number of plots equals 10. If there are no strata
classes following in order, it is combined with the estimation unit previous
in order.
}
\examples{
\donttest{
# NOTE: FIA data objects used in these examples are stored in `FIESTA`, but
# can be generated for populations of interest by the user with functions in
# `FIESTA` such as `spGetPlots()`, `spGetAuxiliary()`, etc. For more
# information, see `FIESTA`'s extensive vignettes.
 
# Population data for counties in Wyoming
modMApop(popTabs = list(tree = FIESTA::WYtree,
                        cond = FIESTA::WYcond),
         pltassgn = FIESTA::WYpltassgn,
         pltassgnid = "CN",
         unitarea = FIESTA::WYunitarea,
         unitvar = "ESTN_UNIT",
         unitzonal = FIESTA::WYunitzonal,
         prednames = c("dem", "tcc", "tpi", "tnt"),
         predfac = "tnt")
         
# Adding seedling data as well
modMApop(popTabs = list(tree = FIESTA::WYtree,
                        cond = FIESTA::WYcond,
                        seed = FIESTA::WYseed),
         pltassgn = FIESTA::WYpltassgn,
         pltassgnid = "CN",
         unitarea = FIESTA::WYunitarea,
         unitvar = "ESTN_UNIT",
         unitzonal = FIESTA::WYunitzonal,
         prednames = c("dem", "tcc", "tpi", "tnt"),
         predfac = "tnt")
}
}
\references{
Scott, Charles T.; Bechtold, William A.; Reams, Gregory A.;
Smith, William D.; Westfall, James A.; Hansen, Mark H.; Moisen, Gretchen G.
2005. Sample-based estimators used by the Forest Inventory and Analysis
national information management system. Gen. Tech. Rep. SRS-80. Asheville,
NC: U.S. Department of Agriculture, Forest Service, Southern Research
Station, p.53-77.
}
\author{
Tracey S. Frescino, Paul L. Patterson
}
\keyword{data}
