% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lfreg.R
\name{lfreg}
\alias{lfreg}
\title{Functional logistic regression model}
\usage{
lfreg(formula, betalist = NULL)
}
\arguments{
\item{formula}{a formula expression of the form \code{response ~ predictors}. On the left side of the formula, \code{y} is a factor variable whereas on the right side,
\code{X} can be either functional data object of class \code{fd} or a scalar variable of class \code{numeric}. The length of a scalar variable must equal the length
of a response variable. Similarly, the number of observations of a functional covariate must equal the length of a response variable.}

\item{betalist}{an optional argument. A list which contains beta regression coefficient functions for independent variables.
If betalist is not provided, the number of estimated beta regression coefficient functions for one functional covariate would equal the number of basis functions used to represent that functional covariate.
For a scalar variable, beta regression coefficient function is also a functional object whose basis is constant.
Needless to say, for a scalar variable, there will be one beta regression coefficient.}
}
\value{
\item{call}{ call of the lfreg function}

\item{x.count}{ number of predictors}

\item{xfdlist}{ a list of functional data objects. The length of the list is equal to the number of predictors}

\item{betalist}{ a list of beta regression coefficient functions}

\item{coefficients}{  estimated beta regression coefficient functions}

\item{fitted.values}{  predicted values of a response variable \code{y}}

\item{loglik}{ a value of log-likelihood function at optimum}

\item{df}{ degrees of freedom}

\item{AIC}{ Akaike information criterion}

\item{iteration}{  number of iterations needed for convergence criterion to be met}
}
\description{
Functional logistic regression model in which the response variable is a factor variable
whereas the independent variables are functional variables. Independent variables could also be scalar variables.
}
\examples{

library(fda)
precipitation_data = CanadianWeather$daily[,,"Precipitation.mm"]
annualprec = apply(precipitation_data,2,sum)
y = ifelse(annualprec<mean(annualprec), 0, 1)
y = as.factor(y)
x = CanadianWeather$daily[,,"Temperature.C"]
xbasis = create.fourier.basis(c(1,365),5) # 5 basis functions
# smoothing of the data and extraction of functional data object
xfd = smooth.basis(c(1:365),x,xbasis)$fd
# bbasis and betalist are optional arguments
bbasis = create.fourier.basis(c(0,365),3) # 3 bf
betalist = list(bbasis)
formula = y ~ xfd
lfreg.model = lfreg(formula, betalist = betalist)
# add scalar variables
latitude = CanadianWeather$coordinates[,1]
longitude = CanadianWeather$coordinates[,2]
# cbasis and betalist are optional arguments
cbasis = create.constant.basis(c(1,365))
betalist = list(bbasis, cbasis, cbasis)
formula = y ~ xfd + latitude + longitude
lfreg.model = lfreg(formula, betalist = betalist)
}
