% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGeneric.R, R/basisfns.R
\name{combine_basis}
\alias{combine_basis}
\alias{combine_basis,list-method}
\alias{combine_basis,Basis-method}
\title{Combine basis functions}
\usage{
combine_basis(Basis_list)

\S4method{combine_basis}{list}(Basis_list)
}
\arguments{
\item{Basis_list}{a list of objects of class \code{Basis}. Each element of the list is assumed to 
represent a single resolution of basis functions}
}
\description{
Takes a list of objects of class \code{Basis} and returns a 
single object of class \code{Basis}.
}
\examples{
## Construct two resolutions of basis functions using local_basis() 
Basis1 <- local_basis(manifold = real_line(), 
                     loc = matrix(seq(0, 1, length.out = 3), ncol = 1), 
                     scale = rep(0.4, 3))

Basis2 <- local_basis(manifold = real_line(), 
                     loc = matrix(seq(0, 1, length.out = 6), ncol = 1), 
                     scale = rep(0.2, 6))

## Combine basis-function resolutions into a single Basis object
combine_basis(list(Basis1, Basis2)) 
}
\seealso{
\code{\link{auto_basis}} for automatically constructing basis functions and \code{\link{show_basis}} for visualising basis functions
}
