#' Catches in removal events of salmon parr.
#'
#' Catches in removal events of salmon parr from the Afon Dulas at Pentre, 19Jun79.
#'
#' @name SalmonADP
#' @docType data
#' @format A data frame with 5 observations on the following 2 variables:
#'  \describe{
#'   \item{catch}{Removal event.}
#'   \item{caught}{Number of fish captured and removed.} 
#'  }
#'
#' @section Topic(s): \itemize{
#'  \item Population size
#'  \item Abundance
#'  \item Removal
#' }
#'
#' @concept Abundance
#' @concept Population Size
#' @concept Removal
#'
#' @seealso \link{TroutADP}
#'
#' @source From Table 2 in Cowx, I.G. 1983. Review of the methods for estimating fish population size from survey removal data. Fisheries Management, 14:67-82.
#'
#' @keywords datasets
#'
#' @examples
#' data(SalmonADP)
#' str(SalmonADP)
#' SalmonADP
#'
NULL