% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_fsk.R
\name{create_fsk}
\alias{create_fsk}
\title{Creates an FSK model from an existing R script}
\usage{
create_fsk(
  r_model,
  r_visualization = NULL,
  readme = NULL,
  other_files = NULL,
  pckg_frame = NULL
)
}
\arguments{
\item{r_model}{character with the path to the R script with the model.}

\item{r_visualization}{(optional) character with the path to the R
script with the visualization.}

\item{readme}{(optional) path to README file.}

\item{other_files}{(optional) character vector with the path to additional}

\item{pckg_frame}{(optional) data.frame with 2 columns `Package`
files required by the model.}
}
\value{
An instance of FSK2R.
}
\description{
The model includes the R model. If provided as arguments, it also includes
the visualization script and the README. Besides, it generates a typical
model_metadata, as well as a simulation (without parameters).
The manifest is left empty.
}
\examples{
\donttest{
 model_path <- system.file("extdata", "model.r", package = "FSK2R")
 visualization_path <- system.file("extdata", "visualization.r", package = "FSK2R")
 FSK_from_R <- create_fsk(model_path, visualization_path)
}

}
