% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consistency.R
\name{roughsetConsistency}
\alias{roughsetConsistency}
\title{Rough Set consistency measure}
\usage{
roughsetConsistency()
}
\value{
Returns a function that is used to generate an evaluation set measure using the rough sets consistency value for the selected features.
}
\description{
Generates an evaluation function that calculates the rough sets consistency value \insertCite{Pawlak1982}{FSinR} \insertCite{Pawlak1991}{FSinR}, using hash tables (set measure). This function is called internally within the \code{\link{filterEvaluator}} function.
}
\examples{
\dontrun{ 

## The direct application of this function is an advanced use that consists of using this 
# function directly to evaluate a set of features
## Classification problem

# A discrete dataset is used (in this case we use only several discrete columns)
adult <- adult[,c(4,9,10,15)]

# Generate the evaluation function with Rough Set Consistency
rsc_evaluator <- roughsetConsistency()
# Evaluate the features (parameters: dataset, target variable and features)
rsc_evaluator(adult,'income',c('race','sex','education'))
}
}
\references{
\insertAllCited{}
}
\author{
Adan M. Rodriguez
}
