\name{run.lrg.peaks}
\alias{run.lrg.peaks}
\title{Extract "Large" Peaks from Files}
\description{
Takes the files output by \code{\link{run.peaks}}, extracts \dQuote{large} peaks, combines them
into a single data frame, and writes the data frame to a file.
}
\usage{
run.lrg.peaks(trans.method = "shiftedlog", add.par = 0, subtract.base = FALSE,
              root.dir = ".", peak.dir, base.dir, lrg.dir,
              lrg.file = lrg_peaks.RData, overwrite = FALSE,
              use.par.file = FALSE, par.file = "parameters.RData",
              calc.all.peaks = FALSE, gengamma.quantiles = TRUE,
              peak.thresh = 3.798194)
}
\arguments{
    \item{trans.method}{type of transformation to use on spectra before statistical analysis; currently, only \code{"shiftedlog"}, \code{"glog"}, and \code{"none"} are supported}
    \item{add.par}{additive parameter for \code{"shiftedlog"} or \code{"glog"} options for \code{trans.method}}
    \item{subtract.base}{logical; whether to subtract calculated baseline from spectrum}
    \item{root.dir}{directory for parameters file and raw data}
    \item{peak.dir}{directory for peak location files; default is \code{paste(root.dir, "/All_Peaks", sep = "")}}
    \item{base.dir}{directory for baseline files; default is \code{paste(root.dir, "/Baselines", sep = "")}}
    \item{lrg.dir}{directory for large peaks file; default is \code{paste(root.dir, "/Large_Peaks", sep = "")}}
    \item{lrg.file}{name of file to store large peaks in}
    \item{overwrite}{whether to replace exisiting files with new ones}
    \item{use.par.file}{logical; if \code{TRUE}, then parameters are read from \code{par.file} in directory \code{root.dir}}
    \item{par.file}{string containing name of parameters file}
    \item{calc.all.peaks}{logical; whether to calculate all possible peaks or only sufficiently large ones}
    \item{gengamma.quantiles}{logical; whether to use generalized gamma quantiles when calculating large peaks}
    \item{peak.thresh}{threshold for declaring large peak; see below}
}
\details{Reads in information from each file created by \code{\link{run.peaks}}, extracts peaks which have 
zero weight in the spectrum they come from when using Tukey's biweight with parameter \code{k.biweight}
to estimate center and scale, and creates the file \code{lrg.file} in \code{lrg.dir}.  The resulting file 
contains the data frame \code{lrg.peaks}, which has columns 
\tabular{ll}{ \tab \cr
  \code{Center_hat}\tab estimated mass of peak\cr
  \code{Max_hat}\tab estimated intensity of peak\cr
  \code{Width_hat}\tab estimated width of peak\cr
  \code{File}\tab name of file the peak was extracted from, with \dQuote{\_peaks.RData} deleted\cr
}
    and is ready to be used by \code{\link{run.strong.peaks}}.
}
\value{
No value returned; the file is simply created.
}
\references{
Barkauskas, D.A. (2009) \dQuote{Statistical Analysis of Matrix-Assisted Laser Desorption/Ionization
Fourier Transform Ion Cyclotron Resonance Mass Spectrometry Data with Applications to Cancer
Biomarker Detection}.  Ph.D. dissertation, University of California at Davis.

Barkauskas, D.A. \emph{et al}. (2009) \dQuote{Detecting glycan cancer biomarkers in serum
samples using MALDI FT-ICR mass spectrometry data}.  \emph{Bioinformatics}, \bold{25}:2, 251--257.
}
\author{Don Barkauskas (\email{barkda@wald.ucdavis.edu})}
\note{
If \code{gengamma.quantiles = TRUE}, then a peak is \dQuote{large} if it is at least \code{peak.thresh}
times as large as the estimated baseline at that point.

If \code{gengamma.quantiles = FALSE}, then a peak is \dQuote{large} if it has zero weight in the data
generated by \code{\link{run.peaks}} for the spectrum it comes from when using Tukey's biweight with
parameter \code{3/2*peak.thresh} to estimate center and scale.

If \code{use.par.file = TRUE}, then the parameters read in from the file overwrite any arguments entered in the
function call.}
\seealso{\code{\link{run.peaks}}, \code{\link{run.cluster.matrix}}}
\examples{}