% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_funcs.R
\name{farm.mean}
\alias{farm.mean}
\title{Mean estimation with Huber's loss function}
\usage{
farm.mean(X)
}
\arguments{
\item{X}{a n x p data matrix with each row being a sample.}
}
\value{
A list with the following items
\item{muhat}{the mean vector}
}
\description{
This function estimates mean of multivariate data using the Huber's loss. The tuning parameter is chosen by cross validation.
}
\examples{
set.seed(100)
p = 20
n = 10
X = matrix(rnorm( p*n, 0,1), nrow = n)
muhat = farm.mean(X)

}
\references{
Huber, P.J. (1964). "Robust Estimation of a Location Parameter." The Annals of Mathematical Statistics, 35, 73–101.
}
