% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastCUB.R
\name{fastCUB}
\alias{fastCUB}
\title{Main function for fast estimation CUB models}
\usage{
fastCUB(Formula, data, ...)
}
\arguments{
\item{Formula}{Object of class Formula.}

\item{data}{Data frame from which model matrices and response variables are taken.}

\item{...}{Additional arguments to be passed for the specification of the model, including covariates matrices Y, W, X for
#' for uncertainty, feeling and shelter, respectively.}
}
\value{
An object of the class "fastCUB": returns a list containing the following results:
\item{estimates}{Maximum likelihood estimates: \eqn{(\pi, \xi)}}
\item{loglik}{Log-likelihood function at the final estimates}
\item{varmat}{Variance-covariance matrix of final estimates}
\item{niter}{Number of executed iterations}
\item{BIC}{BIC index for the estimated model}
}
\description{
Main function to estimate and validate a CUB model for explaining uncertainty
and feeling for given ratings, with or without covariates, on the basis of Louis' identity for the information matrix and the derived accelerated estimation.
}
\details{
This is the main function for CUB models, which calls for the corresponding functions whenever
covariates are specified. It performs maximum likelihood estimation via the E-M algorithm
for CUB models and extensions based on the Louis'identity for the observed information matrix.
}
\seealso{
\code{\link{probcub00}}, \code{\link{probcubp0}}, \code{\link{probcub0q}}, \code{\link{probcubpq}},
}
\keyword{package}
