% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_Z.R
\name{make_Z}
\alias{make_Z}
\title{Random Fourier Feature matrix \eqn{Z} construction for given datasets}
\arguments{
\item{X}{Design matrix \eqn{X \in \mathbb{R}^{n \times d}} (rows  \eqn{x_i \in \mathbb{R}^d}).}

\item{W}{Random frequency matrix \eqn{\omega \in \mathbb{R}^{m \times d}}
(row \eqn{j} is \eqn{\omega_j^\top \in \mathbb{R}^d}), drawn i.i.d. from the spectral density of the chosen kernel:
\itemize{
  \item Gaussian: \eqn{\omega_{jk} \sim \text{i.i.d. } \mathcal{N}(0, 2\rho)}.
  \item Laplace: \eqn{\omega_{jk} \sim\text{i.i.d. } \mathrm{Cauchy}(0, 1/2\rho)}
}}

\item{b}{Random phase vector \eqn{b \in \mathbb{R}^m}, i.i.d. \eqn{\mathrm{Unif}[0,\,2\pi]}.}

\item{n_threads}{Number of parallel threads.
The default is 4. If the system does not support 4 threads,
it automatically falls back to 1 thread.}
}
\value{
Random Fourier Feature matrix \eqn{Z}
}
\description{
Constructs a Random Fourier Feature matrix \eqn{Z \in \mathbb{R}^{n \times m}} with
\eqn{Z_{ij} = z_j(x_i) = \sqrt{2/m}\cos(\omega_j^\top x_i + b_j), \quad j = 1, \cdots, m,
 \quad i = 1, \cdots, n}.
Implemented in C++ via RcppArmadillo.
}
\examples{
set.seed(1)
lambda = 1e-4
d = 1
rho = 1
n = 50
X = matrix(runif(n*d, 0, 1), nrow = n, ncol = d)
m = ceiling(n* log(d + 5)/ 10)
y = as.vector(sin(2*pi*rowMeans(X)^3) + rnorm(n, 0, 0.1))
rv = rff_random(m = m, d = d, rho = 1, kernel = "gaussian")
str(rv)

Z = make_Z(X, rv$W, rv$b)
str(Z)

}
