% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/z_data.R
\name{getDSdata}
\alias{getDSdata}
\title{Get DS Dataset}
\usage{
getDSdata()
}
\description{
A function to extract the log-returns
of 16 financial series and time series provided by the packages \code{datasets}
(EuStockMarkets, sunspot.year) and \code{timeSeries} (USDCHF, MSFT, LPP2005REC).
The 16 datasets are converted to a list of numeric without any reference
to the original dates. This list is usually called \code{DS}, hence the name.
}
\details{
The dataset is usually called by the instruction \code{DS <- getDSdata()}.
Then, it is used with a call to DS[[j]] with j in 1:16.
\enumerate{
  \item{ 1: "USDCHF" (USDCHF, timeSeries) }
  \item{ 2: "MSFT" (MSFT, timeSeries) }
  \item{ 3: "DAX" (EuStockMarkets, datasets) }
  \item{ 4: "SMI" (EuStockMarkets, datasets) }
  \item{ 5: "CAC" (EuStockMarkets, datasets) }
  \item{ 6: "FTSE" (EuStockMarkets, datasets) }
  \item{ 7: "SBI" (LPP2005REC, timeSeries) }
  \item{ 8: "SPI" (LPP2005REC, timeSeries) }
  \item{ 9: "SII" (LPP2005REC, timeSeries) }
  \item{10: "LMI" (LPP2005REC, timeSeries) }
  \item{11: "MPI" (LPP2005REC, timeSeries) }
  \item{12: "ALT" (LPP2005REC, timeSeries) }
  \item{13: "LPP25" (LPP2005REC, timeSeries) }
  \item{14: "LPP40" (LPP2005REC, timeSeries) }
  \item{15: "LPP60" (LPP2005REC, timeSeries) }
  \item{16: "sunspot" (sunspot.year, datasets) }
}
Note that \code{sunspot.year} is regularly updated with each new version of
\code{R}.
}
\examples{
require(timeSeries)
getDSdata
DS  <- getDSdata()
attributes(DS)
for (j in 1:16) {print(head(DS[[j]]))}
}
\seealso{
\code{\link[datasets]{EuStockMarkets}}, \code{\link[datasets]{sunspot.year}},
\code{\link[timeSeries]{TimeSeriesData}}, \code{\link{regkienerLX}},
\code{\link{estimkienerX}}
}

