% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FcircSEC.R
\name{circClassification}
\alias{circClassification}
\title{circRNA classification using trancript information and the bed file from the circRNA prediction tools}
\usage{
circClassification(transcriptdata, bedfile, outfiletxt, outfilebed)
}
\arguments{
\item{transcriptdata}{The transcript data (obtained from function \code{\link[FcircSEC]{transcriptExtract}})}

\item{bedfile}{The bed file (obtained from the circRNA prediction tools) having four columns chromosome, circRNA start, circRNA end position and circRNA strand}

\item{outfiletxt}{The output file with the detailed information of circRNA classification}

\item{outfilebed}{The output file with chromosome, start and end position of each circRNAs}
}
\value{
The detailed information of circRNA classification will be written in outfiletxt and only chromosome, start and end position of each circRNAs will be written in outfilebed
}
\description{
This function classifies circRNAs using the transcript information obtained from annotation file and the bedfile obtained from the circRNA prediction tools
}
\examples{

#Loading and example transcript data and write to a file
#Here temporary directory is created as input-output
#directory. Please provide you own directory instead.
out_dir<-tempdir()
t_data<-data("transcript_data") 
t_data<-transcript_data
write.table(t_data, file.path(out_dir,"transcript_data.txt"), row.names=FALSE)

#Loading an example bedfile obtained form the circRNA prediction tool and write to a file
b_file<-data("output_CIRI")
b_file<-output_CIRI
write.table(b_file, file.path(out_dir,"output_CIRI.bed"), col.names=FALSE, row.names=FALSE)

#Classification of circRNAs. Here, the output will be written in two files 
#circRNA_class.txt and circRNA_class.bed in out_dir directory
circClassification (file.path(out_dir,"transcript_data.txt"), 
   file.path(out_dir,"output_CIRI.bed"), file.path(out_dir, "circRNA_class.txt"), 
   file.path(out_dir, "circRNA_class.bed"))

}
