% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Table1.R
\name{createTable1}
\alias{createTable1}
\title{Create a table 1}
\usage{
createTable1(
  covariateData1,
  covariateData2 = NULL,
  cohortId1 = NULL,
  cohortId2 = NULL,
  specifications = getDefaultTable1Specifications(),
  output = "two columns",
  showCounts = FALSE,
  showPercent = TRUE,
  percentDigits = 1,
  valueDigits = 1,
  stdDiffDigits = 2
)
}
\arguments{
\item{covariateData1}{The covariate data of the cohort to be included in the table.}

\item{covariateData2}{The covariate data of the cohort to also be included, when comparing two
cohorts.}

\item{cohortId1}{If provided, \code{covariateData1} will be restricted to this cohort. If not
provided, \code{covariateData1} is assumed to contain data on only 1 cohort.}

\item{cohortId2}{If provided, \code{covariateData2} will be restricted to this cohort. If not
provided, \code{covariateData2} is assumed to contain data on only 1 cohort.}

\item{specifications}{Specifications of which covariates to display, and how.}

\item{output}{The output format for the table. Options are \code{output = "two columns"},
\code{output = "one column"}, or \code{output = "list"}.}

\item{showCounts}{Show the number of cohort entries having the binary covariate?}

\item{showPercent}{Show the percentage of cohort entries having the binary covariate?}

\item{percentDigits}{Number of digits to be used for percentages.}

\item{valueDigits}{Number of digits to be used for the values of continuous variables.}

\item{stdDiffDigits}{Number of digits to be used for the standardized differences.}
}
\value{
A data frame, or, when \code{output = "list"} a list of two data frames.
}
\description{
Creates a formatted table of cohort characteristics, to be included in publications or reports.
Allows for creating a table describing a single cohort, or a table comparing two cohorts.
}
\examples{
\donttest{
eunomiaConnectionDetails <- Eunomia::getEunomiaConnectionDetails()
covSettings <- createDefaultCovariateSettings()
Eunomia::createCohorts(
  connectionDetails = eunomiaConnectionDetails,
  cdmDatabaseSchema = "main",
  cohortDatabaseSchema = "main",
  cohortTable = "cohort"
)
covData1 <- getDbCovariateData(
  connectionDetails = eunomiaConnectionDetails,
  oracleTempSchema = NULL,
  cdmDatabaseSchema = "main",
  cdmVersion = "5",
  cohortTable = "cohort",
  cohortDatabaseSchema = "main",
  cohortTableIsTemp = FALSE,
  cohortId = 1,
  rowIdField = "subject_id",
  covariateSettings = covSettings,
  aggregated = TRUE
)
covData2 <- getDbCovariateData(
  connectionDetails = eunomiaConnectionDetails,
  oracleTempSchema = NULL,
  cdmDatabaseSchema = "main",
  cdmVersion = "5",
  cohortTable = "cohort",
  cohortDatabaseSchema = "main",
  cohortTableIsTemp = FALSE,
  cohortId = 2,
  rowIdField = "subject_id",
  covariateSettings = covSettings,
  aggregated = TRUE
)
table1 <- createTable1(
  covariateData1 = covData1,
  covariateData2 = covData2,
  cohortId1 = 1,
  cohortId2 = 2,
  specifications = getDefaultTable1Specifications(),
  output = "one column",
  showCounts = FALSE,
  showPercent = TRUE,
  percentDigits = 1,
  valueDigits = 1,
  stdDiffDigits = 2
)
}

}
