/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.sql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    public static final String REGEX_ESCAPED_APOSTROPHES = "(['\"])((?!\\1).|\\1{2})*\\1";
    public static final String HINT_KEY_WORD = "hint";

    public static String replaceCharAt(String string, int pos, char ch) {
        return string.substring(0, pos) + ch + string.substring(pos + 1);
    }

    public static String replace(String string, int start, int end, String replacement) {
        if (end > string.length()) {
            return string.substring(0, start) + replacement;
        }
        return string.substring(0, start) + replacement + string.substring(end);
    }

    public static String replaceAll(String result, String search, String replace) {
        int pos = 0;
        while ((pos = result.indexOf(search, pos)) != -1) {
            result = StringUtils.replace(result, pos, pos + search.length(), replace);
            pos += replace.length();
        }
        return result;
    }

    public static List<Token> tokenizeSql(String sql) {
        int cursor;
        ArrayList<Token> tokens = new ArrayList<Token>();
        int start = 0;
        boolean commentType1 = false;
        boolean commentType2 = false;
        boolean inSingleQuotes = false;
        boolean inDoubleQuotes = false;
        for (cursor = 0; cursor < sql.length(); ++cursor) {
            Token token;
            char ch = sql.charAt(cursor);
            if (commentType1) {
                if (ch != '\n') continue;
                commentType1 = false;
                start = cursor + 1;
                continue;
            }
            if (commentType2) {
                if (ch != '/' || cursor <= 0 || sql.charAt(cursor - 1) != '*') continue;
                commentType2 = false;
                start = cursor + 1;
                continue;
            }
            if (Character.isLetterOrDigit(ch) || ch == '_' || ch == '@') continue;
            if (cursor > start) {
                token = new Token();
                token.start = start;
                token.end = cursor;
                token.text = sql.substring(start, cursor);
                token.inQuotes = inSingleQuotes || inDoubleQuotes;
                tokens.add(token);
            }
            if (!(ch != '-' || cursor >= sql.length() || sql.charAt(cursor + 1) != '-' || inSingleQuotes || inDoubleQuotes || sql.length() - cursor >= 6 && sql.substring(cursor + 2, cursor + 6).equals(HINT_KEY_WORD))) {
                commentType1 = true;
            } else if (ch == '/' && cursor < sql.length() && sql.charAt(cursor + 1) == '*' && !inSingleQuotes && !inDoubleQuotes) {
                commentType2 = true;
            } else if (!Character.isWhitespace(ch)) {
                token = new Token();
                token.start = cursor;
                token.end = cursor + 1;
                token.text = sql.substring(cursor, cursor + 1);
                token.inQuotes = inSingleQuotes || inDoubleQuotes;
                tokens.add(token);
                if (ch == '\'' && !inDoubleQuotes) {
                    boolean bl = inSingleQuotes = !inSingleQuotes;
                }
                if (ch == '\"' && !inSingleQuotes) {
                    inDoubleQuotes = !inDoubleQuotes;
                }
            }
            start = cursor + 1;
        }
        if (cursor > start && !commentType1 && !commentType2) {
            Token token = new Token();
            token.start = start;
            token.end = cursor;
            token.text = sql.substring(start, cursor);
            token.inQuotes = inSingleQuotes || inDoubleQuotes;
            tokens.add(token);
        }
        return tokens;
    }

    public static List<String> safeSplit(String string, char delimiter) {
        int i;
        ArrayList<String> result = new ArrayList<String>();
        if (string.length() == 0) {
            result.add("");
            return result;
        }
        boolean literal = false;
        boolean escape = false;
        int startpos = 0;
        for (i = 0; i < string.length(); ++i) {
            char currentchar = string.charAt(i);
            if (currentchar == '\"' && !escape) {
                boolean bl = literal = !literal;
            }
            if (!literal && currentchar == delimiter && !escape) {
                result.add(string.substring(startpos, i));
                startpos = i + 1;
            }
            escape = currentchar == '\\' ? !escape : false;
        }
        result.add(string.substring(startpos, i));
        return result;
    }

    public static String join(Collection<?> s, String delimiter) {
        StringBuilder result = new StringBuilder();
        Iterator<?> iter = s.iterator();
        if (iter.hasNext()) {
            result.append(iter.next().toString());
        }
        while (iter.hasNext()) {
            result.append(delimiter);
            result.append(iter.next().toString());
        }
        return result.toString();
    }

    public static List<String> splitAndKeep(String val, String regex) {
        ArrayList<String> result = new ArrayList<String>();
        Matcher matcher = Pattern.compile(regex).matcher(val);
        int pos = 0;
        while (matcher.find()) {
            result.add(val.substring(pos, matcher.start()));
            result.add(matcher.group());
            pos = matcher.end();
        }
        if (pos < val.length()) {
            result.add(val.substring(pos));
        }
        return result;
    }

    public static String replaceWithConcat(String val) {
        return StringUtils.replaceWith(val, new StringFunction(){

            @Override
            public String apply(String t) {
                if (!t.equals("''")) {
                    List<String> literals = StringUtils.splitAndKeep(t, "''");
                    StringBuilder result = new StringBuilder();
                    int size = literals.size();
                    for (int i = 0; i < size; ++i) {
                        String literal = literals.get(i);
                        StringBuilder sb = new StringBuilder().append("'");
                        if (literal.matches("''")) {
                            sb.append("\\047");
                        } else {
                            sb.append(literal.replaceAll("'", "").replaceAll("\\\\", Matcher.quoteReplacement("\\\\")).replaceAll("\"", Matcher.quoteReplacement("\\042")).replaceAll("/", Matcher.quoteReplacement("\\/")));
                        }
                        sb.append("'");
                        result.append((CharSequence)sb);
                        if (i >= size - 1) continue;
                        result.append(",");
                    }
                    return "CONCAT(" + result.toString() + ")";
                }
                return t;
            }
        });
    }

    private static String replaceWith(String val, StringFunction func) {
        List<String> tokens = StringUtils.splitAndKeep(val, REGEX_ESCAPED_APOSTROPHES);
        StringBuilder result = new StringBuilder();
        for (String token : tokens) {
            if (token.matches(REGEX_ESCAPED_APOSTROPHES) && token.contains("''")) {
                result.append(func.apply(token));
                continue;
            }
            result.append(token);
        }
        return result.toString();
    }

    static interface StringFunction {
        public String apply(String var1);
    }

    public static class Token {
        public int start;
        public int end;
        public String text;
        public boolean inQuotes = false;

        public Token(Token other) {
            this.start = other.start;
            this.end = other.end;
            this.text = other.text;
        }

        public Token() {
        }

        public boolean isIdentifier() {
            for (int i = 0; i < this.text.length(); ++i) {
                char ch = this.text.charAt(i);
                if (Character.isLetterOrDigit(ch) || ch == '_') continue;
                return false;
            }
            return true;
        }
    }
}

