% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DAYMET_FUNCTIONS.R
\name{get_daymet}
\alias{get_daymet}
\title{Download and crop the 1-km DAYMET v4 daily weather dataset.}
\usage{
get_daymet(
  template,
  label,
  elements = c("dayl", "prcp", "srad", "swe", "tmax", "tmin", "vp"),
  years = 1980:(lubridate::year(Sys.time()) - 1),
  region = "na",
  tempo = "day",
  extraction.dir = file.path(tempdir(), "FedData", "extractions", "daymet", label),
  raster.options = c("COMPRESS=DEFLATE", "ZLEVEL=9", "INTERLEAVE=BAND"),
  force.redo = FALSE,
  progress = TRUE
)
}
\arguments{
\item{template}{An \code{\link[sf:sf]{Simple Feature}}
or \code{\link[terra:SpatRaster-class]{SpatRaster}} object to serve as a template for cropping.}

\item{label}{A character string naming the study area.}

\item{elements}{A character vector of elements to extract.\cr
The available elements are:\cr
dayl = Duration of the daylight period in seconds per day. This calculation is based on the period of the day during which the sun is above a hypothetical flat horizon.\cr
prcp = Daily total precipitation in millimeters per day, sum of all forms converted to water-equivalent. Precipitation occurrence on any given day may be ascertained.\cr
srad = Incident shortwave radiation flux density in watts per square meter, taken as an average over the daylight period of the day. NOTE: Daily total radiation (MJ/m2/day) can be calculated as follows: ((srad (W/m2) * dayl (s/day)) / l,000,000)\cr
swe = Snow water equivalent in kilograms per square meter. The amount of water contained within the snowpack.\cr
tmax = Daily maximum 2-meter air temperature in degrees Celsius.\cr
tmin = Daily minimum 2-meter air temperature in degrees Celsius.\cr
vp = Water vapor pressure in pascals. Daily average partial pressure of water vapor.\cr}

\item{years}{A numeric vector of years to extract.}

\item{region}{The name of a region. The available regions are:\cr
na = North America\cr
hi = Hawaii\cr
pr = Puerto Rico\cr}

\item{tempo}{The frequency of the data. The available tempos are:\cr
day = Daily data\cr
mon = Monthly summary data\cr
ann = Annual summary data\cr}

\item{extraction.dir}{A character string indicating where the extracted and cropped DEM should be put.
Defaults to a temporary directory.}

\item{raster.options}{a vector of GDAL options passed to \link[terra:writeRaster]{terra::writeRaster}.}

\item{force.redo}{If an extraction for this template and label already exists in extraction.dir,
should a new one be created?}

\item{progress}{Draw a progress bar when downloading?}
}
\value{
A named list of \code{SpatRaster}s of weather data cropped to the extent of the template.
}
\description{
\code{get_daymet} returns a \code{\link[terra:SpatRaster-class]{SpatRaster}} of weather data cropped to a given
template study area.
}
\examples{
\dontrun{

# Get the DAYMET (North America only)
# Returns a list of raster bricks
DAYMET <- get_daymet(
  template = FedData::meve,
  label = "meve",
  elements = c("prcp", "tmin", "tmax"),
  years = 1980:1985
)

# Plot with terra::plot
plot(DAYMET$tmin$X1985.10.23)
}
}
