% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_do_optim.R
\name{multi_location_prep}
\alias{multi_location_prep}
\title{Optimized multi-location partially replicated design}
\usage{
multi_location_prep(
  lines,
  nrows,
  ncols,
  l,
  planter = "serpentine",
  plotNumber,
  desired_avg,
  copies_per_entry,
  checks = NULL,
  rep_checks = NULL,
  exptName,
  locationNames,
  optim_list,
  seed,
  data = NULL
)
}
\arguments{
\item{lines}{Number of genotypes, experimental lines or treatments.}

\item{nrows}{Numeric vector with the number of rows field at each location.}

\item{ncols}{Numeric vector with the number of columns field at each location.}

\item{l}{Number of locations. By default \code{l = 1}.}

\item{planter}{Option for \code{serpentine} or \code{cartesian} movement. By default  \code{planter = 'serpentine'}.}

\item{plotNumber}{Numeric vector with the starting plot number for each location. By default \code{plotNumber = 101}.}

\item{desired_avg}{(optional) Desired average of treatments across locations.}

\item{copies_per_entry}{Number of total copies per treatment.}

\item{checks}{Number of checks.}

\item{rep_checks}{Number of replications per check.}

\item{exptName}{(optional) Name of the experiment.}

\item{locationNames}{(optional) Name for each location.}

\item{optim_list}{(optional) A list object of class "MultiPrep"generated by \code{do_optim()} function.}

\item{seed}{(optional) Real number that specifies the starting seed to obtain reproducible designs.}

\item{data}{(optional) Data frame with 2 columns: \code{ENTRY | NAME }. ENTRY must be numeric.}
}
\value{
A list of class \code{FielDHub} with several elements.
\itemize{
  \item \code{infoDesign} is a list with information on the design parameters.
  \item \code{layoutRandom} is a matrix with the randomization layout.
  \item \code{plotNumber} is a matrix with the layout plot number.
  \item \code{binaryField} is a matrix with the binary field.
  \item \code{dataEntry} is a data frame with the data input.
  \item \code{genEntries} is a list with the entries for replicated and non-replicated parts.
  \item \code{fieldBook} is a data frame with field book design. This includes the index (Row, Column).
  \item \code{min_pairswise_distance} is a data frame with the minimum pairwise distance between 
             each pair of locations.
  \item \code{reps_info} is a data frame with information on the number of replicated and 
             non-replicated treatments at each location.
  \item \code{pairsDistance} is a data frame with the pairwise distances between each pair of 
             treatments.
  \item \code{treatments_with_reps} is a list with the entries for the replicated part of the design.
  \item \code{treatments_with_no_reps} is a list with the entries for the non-replicated part of the design.
  \item \code{list_locs} is a list with each location list of entries.
  \item \code{allocation} is a matrix with the allocation of treatments.
  \item \code{size_locations} is a data frame with one column for each 
             location and one row with the size of the location.
}
}
\description{
Optimized multi-location partially replicated design
}
\examples{
# Example 1: Generates a spatially optimized multi-location p-rep design with 142 
# genotypes. The number of copies per plant available for this experiment is 9. 
# This experiment is carried out in 5 locations, and there are seven seeds available 
# for each plant to make replications.
# In this case, we add three controls (checks) with six reps each.
# With this setup, the experiment will have 142 treatments + 3 checks = 145 
# entries and the number of plots per location after the allocation process 
# will be 196. 
# The average genotype allocation will be 1.5 copies per location.
\dontrun{
optim_multi_prep <- multi_location_prep(
  lines = 150,  
  l = 5, 
  copies_per_entry = 7, 
  checks = 3, 
  rep_checks = c(6,6,6),
  locationNames = c("LOC1", "LOC2", "LOC3", "LOC4", "LOC5"), 
  seed = 1234
)
designs <- optim_multi_prep$designs
field_book_loc_1 <- designs$LOC1$fieldBook
head(field_book_loc_1, 10)
}
}
\references{
Edmondson, R.N. Multi-level Block Designs for Comparative Experiments. JABES 25, 
500–522 (2020). https://doi.org/10.1007/s13253-020-00416-0
}
\author{
Didier Murillo [aut],
        Salvador Gezan [aut],
        Jean-Marc Montpetit [ctb],
        Ana Heilman [ctb]
}
