% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{df_gv_unstr}
\alias{df_gv_unstr}
\title{Genetic values - example data frame}
\format{
A data frame with 700 rows and 5 columns:
\describe{
  \item{env}{Environment id}
  \item{rep}{Replicate id}
  \item{id}{Genotype id}
  \item{gv.Trait.1}{Simulated genetic values for trait 1}
  \item{gv.Trait.2}{Simulated genetic values for trait 2}
}
}
\usage{
df_gv_unstr
}
\description{
An example data frame of simulated genetic values for 100 genotypes with two traits across
three environments. The data frame was generated using the wrapper functions
\link[FieldSimR]{unstr_asr_input} and \link[FieldSimR]{unstr_asr_output} to simulate correlated
genetic values based on an unstructured model for genotype-by-environment (GxE) interaction
with \href{https://CRAN.R-project.org/package=AlphaSimR}{`AlphaSimR'}. The simulation of
the genetic values is shown in the vignette on the
\href{https://crwerner.github.io/fieldsimr/articles/unstructured_GxE_demo.html}{Simulation of genetic values using an unstructured GxE interaction model}.
}
\keyword{datasets}
