% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_effects.R
\name{plot_matrix}
\alias{plot_matrix}
\title{Graphics for matrices}
\usage{
plot_matrix(mat, order = FALSE, group.df = NULL, labels = TRUE)
}
\arguments{
\item{mat}{A symmetric matrix.}

\item{order}{When \code{TRUE} (default is \code{FALSE}), the function \code{agnes} of the R package
\href{https://cran.r-project.org/package=cluster}{`cluster`} is used with default arguments to
order the matrix based on a dendrogram.}

\item{group.df}{An optional data frame with columns containing the variable names followed by the group numbers.
When supplied, the heatmap is split into groups and then ordered (when \code{order = TRUE}).}

\item{labels}{When \code{TRUE} (default), variable labels are displayed.}
}
\value{
A heatmap with x- and y-axes displaying the variable numbers,
  and colour gradient ranging from blue (low value) to red (high value).
}
\description{
Creates a heatmap of a symmetric matrix (e.g., correlation or covariance matrix).
}
\examples{
# Display a random correlation matrix.

corA <- rand_cor_mat(
  n = 10,
  min.cor = -1,
  max.cor = 1
)

# Define groups.

group_df <- data.frame(variable = 1:10, group = c(1, 1, 1, 1, 2, 2, 2, 3, 3, 4))

plot_matrix(
  mat = corA,
  order = TRUE,
  group.df = group_df,
  labels = TRUE
)

}
