% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_predictive.R
\name{posterior_predict.flexreg}
\alias{posterior_predict.flexreg}
\title{Posterior Predictive}
\usage{
\method{posterior_predict}{flexreg}(model, newdata = NULL)
}
\arguments{
\item{model}{an object of class \code{`flexreg`}, usually the result of \code{\link{flexreg}} or \code{\link{flexreg_binom}}.}

\item{newdata}{an optional data frame containing variables with which to predict. If omitted, the fitted values are used.}
}
\value{
An object of class \code{`flexreg_postpred`} containing a matrix with the simulated posterior predictions. Each column refers to a statistical unit to predict.
}
\description{
The function takes an object of class \code{`flexreg`} and generates values from the posterior predictive distribution.
}
\details{
The function generates values from the posterior predictive distribution, which is the distribution of a  future outcome given the observed data.
The posterior predictive distribution is computed for \eqn{y} in case of bounded responses and
for \code{y/n} in case of binomial responses.
}
\examples{
\dontrun{
data("Reading")
FB <- flexreg(accuracy.adj ~ iq, data = Reading, n.iter=1000)
pp <- posterior_predict(FB)
plot(pp)
}

}
\references{
{
Ascari, R., Migliorati, S. (2021). A new regression model for overdispersed binomial data accounting for outliers and an excess of zeros. Statistics in Medicine, \bold{40}(17), 3895--3914. doi:10.1002/sim.9005 \cr
\cr
Di Brisco, A. M., Migliorati, S., Ongaro, A. (2020). Robustness against outliers: A new variance inflated regression model for proportions. Statistical Modelling, \bold{20}(3), 274--309. doi:10.1177/1471082X18821213 \cr
\cr
Gelman, A., Carlin, J. B., Stern, H. S., Rubin, D. B. (2014). Bayesian Data Analysis, 3th edition. Chapman and Hall/CRC. doi:10.1201/b16018 \cr
\cr
Migliorati, S., Di Brisco, A. M., Ongaro, A. (2018). A New Regression Model for Bounded Responses. Bayesian Analysis, \bold{13}(3), 845--872. doi:10.1214/17-BA1079 \cr
}
}
