% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VIB_functions.R
\name{dVIB}
\alias{dVIB}
\alias{qVIB}
\alias{pVIB}
\alias{rVIB}
\title{The Variance-Inflated Beta Distribution}
\usage{
dVIB(x, mu, phi, p, k, q0 = NULL, q1 = NULL, log = FALSE)

qVIB(prob, mu, phi, p, k, q0 = NULL, q1 = NULL, log.prob = FALSE)

pVIB(q, mu, phi, p, k, q0 = NULL, q1 = NULL, log.prob = FALSE)

rVIB(n, mu, phi, p, k, q0 = NULL, q1 = NULL)
}
\arguments{
\item{x, q}{a vector of quantiles.}

\item{mu}{the mean parameter. It must lie in (0, 1).}

\item{phi}{the precision parameter. It must be a real positive value.}

\item{p}{the mixing weight. It must lie in (0, 1).}

\item{k}{the extent of the variance inflation. It must lie in (0, 1).}

\item{q0}{the probability of augmentation in zero. It must lie in (0, 1). In case of no augmentation, it is \code{NULL} (default).}

\item{q1}{the probability of augmentation in one. It must lie in (0, 1). In case of no augmentation, it is \code{NULL} (default).}

\item{log}{logical; if TRUE, densities are returned on log-scale.}

\item{prob}{a vector of probabilities.}

\item{log.prob}{logical; if TRUE, probabilities \code{prob} are given as log(prob).}

\item{n}{the number of values to generate. If \code{length(n) > 1}, the length is taken to be the number required.}
}
\value{
The function \code{dVIB} returns a vector with the same length as \code{x} containing the density values.
The function \code{pVIB} returns a vector with the same length as \code{q} containing the values of the distribution function.
The function \code{qVIB} returns a vector with the same length as \code{prob} containing the quantiles.
The function \code{rVIB} returns a vector of length \code{n} containing the generated random values.
}
\description{
Density function, distribution function, quantile function, and random generation
for the (augmented) variance-inflated beta distribution.
}
\details{
The VIB distribution is a special mixture of two beta distributions with probability density function
\deqn{f_{VIB}(x;\mu,\phi,p,k)=p f_B(x;\mu,\phi k)+(1-p)f_B(x;\mu,\phi),}
for \eqn{0<x<1}, where \eqn{f_B(x;\cdot,\cdot)} is the beta density with a mean-precision parameterization.
Moreover, \eqn{0<p<1} is the mixing weight, \eqn{0<\mu<1} represents the overall (as well as mixture component)
mean, \eqn{\phi>0} is a precision parameter, and \eqn{0<k<1} determines the extent of the variance inflation.
The augmented VIB distribution has density
\itemize{
\item \eqn{q_0}, if \eqn{x=0}
\item \eqn{q_1},  if \eqn{x=1}
\item \eqn{(1-q_0-q_1)f_{VIB}(x;\mu,\phi,p,k)}, if \eqn{0<x<1}
}
where \eqn{0<q_0<1} identifies the augmentation in zero, \eqn{0<q_1<1} identifies the augmentation in one,
and \eqn{q_0+q_1<1}.
}
\examples{
dVIB(x = c(.5,.7,.8), mu = .3, phi = 20, p = .5, k= .5)
dVIB(x = c(.5,.7,.8), mu = .3, phi = 20, p = .5, k= .5, q1 = .1)
dVIB(x = c(.5,.7,.8), mu = .3, phi = 20, p = .5, k= .5, q0 = .2, q1 = .1)

qVIB(prob = c(.5,.7,.8), mu = .3, phi = 20, p = .5, k= .5)
qVIB(prob = c(.5,.7,.8), mu = .3, phi = 20, p = .5, k= .5, q1 = .1)
qVIB(prob = c(.5,.7,.8), mu = .3, phi = 20, p = .5, k= .5, q0 = .2, q1 = .1)

pVIB(q = c(.5,.7,.8), mu = .3, phi = 20, p = .5, k= .5)
pVIB(q = c(.5,.7,.8), mu = .3, phi = 20, p = .5, k= .5, q1 = .1)
pVIB(q = c(.5,.7,.8), mu = .3, phi = 20, p = .5, k= .5, q0 = .2, q1 = .1)

rVIB(n = 100, mu = .5, phi = 30, p = .3, k = .6)
rVIB(n = 100, mu = .5, phi = 30, p = .3, k = .6, q0 = .2, q1 = .1)

}
\references{
{
Di Brisco, A. M., Migliorati, S., Ongaro, A. (2020). Robustness against outliers: A new variance inflated regression model for proportions. Statistical Modelling, \bold{20}(3), 274--309.
doi:10.1177/1471082X18821213
}
}
