% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regime.R
\name{regime}
\alias{regime}
\title{Plot flow regime}
\usage{
regime(TS, q = c(0.9, 0.1), text = "d", by = "hdoy", y.lims = NA)
}
\arguments{
\item{TS}{output from \code{\link{create.ts}} containing a data.frame of flow
time series}

\item{q}{Numeric vector of the upper and lower quantile values.  Default
is c(0.9, 0.1).}

\item{text}{optional character string for margin text, e.g. for station name, 
location, or other notes. Set to NULL if no margin text is wanted, or set to "d" 
to use default text containing the station ID, station name, and province/state 
returned from \code{\link{station.info}}.}

\item{by}{Character string indicating whether to plot the regime by day of 
the hydrologic year (defined using \code{\link{create.ts}}) or by day of 
the calendar year. Options are "doy" (calendar year) or "hdoy" (default, hydrologic year).}

\item{y.lims}{optional user-defined y-axis minimum and maximim. e.g. c(0, 500)}
}
\description{
This function plots the min, max, mean, and two user-defined quantiles of 
daily streamflow to provide visual summary of the flow regime. Area between 
the upper and lower quantile is shaded grey, the dark blue line represents
the mean daily discharge, gray line represents the median daily discharge,
 and the period of record daily maximum and minimum are
shown with the blue points.
}
\examples{
# plot the flow regime of the Caniapiscau River
data(cania.sub.ts)
regime(cania.sub.ts)
}
\author{
Jennifer Dierauer
}

