% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regime.R
\name{regime}
\alias{regime}
\title{Plot flow regime}
\usage{
regime(
  TS,
  q = c(0.9, 0.1),
  title = FALSE,
  hyear.start = 10,
  y.lims = NA,
  legend = TRUE,
  change.margins = TRUE
)
}
\arguments{
\item{TS}{data.frame of streamflow time series loaded with \code{\link{read.flows}}.}

\item{q}{Numeric vector of the upper and lower quantile values.  Default
is c(0.9, 0.1).}

\item{title}{optional plot title. Default is FALSE indicating no plot title is wanted. 
Set to TRUE to use the the default plot title, which will 
look for 'plot title' attribute of the data.frame set by 
\code{\link{set.plot.titles}}. All values other values 
will be used as a custom plot title.}

\item{hyear.start}{Integer indicating the start month for the regime plot. 
Default is 10 (October).}

\item{y.lims}{optional user-defined y-axis minimum and maximum. e.g. c(0, 500)}

\item{legend}{TRUE or FALSE to indicate whether a legend should be included. 
Default is TRUE.}

\item{change.margins}{TRUE or FALSE to indicate whether the user's current 
margin settings should be used, or if the margins should be set within the 
function. Default is TRUE, to set margins to the minimal amount.}
}
\description{
This function plots the min, max, mean, and two user-defined quantiles of 
daily streamflow to provide visual summary of the flow regime. Flow record must 
have at least 10 years of data to produce a plot. A visual summary is not shown for 
any days of the year that are missing >80% of the flow record years. 
Area between the upper and lower quantile is shaded grey, the dark blue line represents
the mean daily discharge, gray line represents the median daily discharge, 
and the period of record daily maximum and minimum are
shown with the blue points.
}
\examples{

# Load example ROBIN streamflow data
robin_path <- system.file("extdata", "ROBIN_example.csv", package = "FlowScreen")

TS <- read.flows(robin_path)
TS <- set.plot.titles(TS)
regime(TS, title = TRUE)
}
\author{
Jennifer Dierauer
}
