% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_observedcounts.R
\name{generate_observedcounts}
\alias{generate_observedcounts}
\title{Generate observed counts from the set of bird trajectories.}
\usage{
generate_observedcounts(migr, traj, mask)
}
\arguments{
\item{migr}{A migration structure (attributes site_name, horizon, initial_state are used).}

\item{traj}{A trajectory matrix with a trajectory for each bird.
For each bird, at each time step (from 0 to horizon), position of the bird.
positions: sites, 0 for flying, -1 for dead.
matrix N x (horizon + 1)}

\item{mask}{Boolean matrix (horizon x S) indicating the available observations,
(mask(t,i)=TRUE if site i is observed at time t).}
}
\value{
Counts of observed birds on sites for time steps from 1 to horizon, 
 from the provided set of bird trajectories,
 matrix (S + 2) x (horizon + 1).
 At each time step, count of birds observed on each site.
 NA correspond to non observation.
 For compatibility with trajectory, the first column (time step 0) and 
 the 2 last rows ( S+1 and S+2) are kept and filled with NA.
}
\description{
Generate observed counts from the set of bird trajectories.
}
\examples{
migr <- generate_toy_migration()
traj <- generate_trajectories( migr )
obs <- generate_observedcounts( migr, traj )
}
