% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_trajectories.R
\name{generate_trajectories}
\alias{generate_trajectories}
\title{Generate trajectories of birds.}
\usage{
generate_trajectories(migr, traj = NULL, end_time = migr$horizon)
}
\arguments{
\item{migr}{A migration structure (attributes \emph{site_name}, \emph{initial_state}, \emph{flight_duration}, 
\emph{death_probability}, \emph{transition_law_param}, \emph{sojourn_law_param}, \emph{sojourn_law_type} are used).}

\item{traj}{Partial trajectories, matrix N x (horizon+1) that are going to be extended in time.
If NULL, it is initialized from migr structure.}

\item{end_time}{Time until which simulation is required.
If NULL, it is initialized with migr horizon.}
}
\value{
A trajectory matrix N x (horizon+1) defining a trajectory for each bird.
 A trajectory for one bird, specifies at each time step
 (from 0 to horizon) the state of the bird. Incomplete trajectories
 finishing with NA are returned if the argument end_time is set a value above migr horizon.
}
\description{
Generate trajectories of birds.
A bird trajectory specifies, at each time step, the state of the bird:
a site number in 1...S, 0 for flying, -1 for dead and  NA for unknown.
If partial trajectories (positions of birds are not known until the horizon specified in migration structure) 
are provided with the argument traj, they are simulated until a time limit defined by the argument
\emph{end_time}.
}
\examples{
migr <- generate_toy_migration()
traj <- generate_trajectories( migr )
}
