% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_freeparametersvalue.R
\name{set_freeparametersvalue}
\alias{set_freeparametersvalue}
\title{Assign free parameter values to a migration structure.}
\usage{
set_freeparametersvalue(
  migr,
  values,
  update_transitions = TRUE,
  update_sojourns = NULL,
  use_adhoc_dirichlet = FALSE
)
}
\arguments{
\item{migr}{A migration structure.}

\item{values}{Parameter values to set to the migration structure.
these are the transition probabilities and sojourn mean time.}

\item{update_transitions}{If TRUE, transitions are unknown and the values 
should be given in the vector 'values'.}

\item{update_sojourns}{Vector of boolean, that identifies which sojourn times
should be given.}

\item{use_adhoc_dirichlet}{If TRUE, the transition probabilities are 
considered as the ad hoc dirichlet (\eqn{q_ij} values)
explained in the documentation of the extract_parameters function.}
}
\value{
A migration structure with \emph{migr} attributes except\emph{transition_law_param} and \emph{sojourn_law_param}
that are changed.
}
\description{
Set values to free parameters. Indeed taking into account sites order,
known impossible sites links, sites dead probability, not all the sites transition probabilities
have to be estimated. Others parameters values may be evaluated from free parameters.
}
\examples{
 migr <- generate_toy_migration()
 param <- get_freeparametersvalue(migr) # just for example purpose, should be different values
 set_freeparametersvalue(migr, param)
}
