% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cmatrix.R
\name{Cmatrix}
\alias{Cmatrix}
\title{Cross-sectional (contemporaneous) aggregation matrix}
\usage{
Cmatrix(formula, data, sep = "_", sparse = TRUE, top_label = "Total")
}
\arguments{
\item{formula}{Specification of the hierarchical structure: grouped hierarchies are specified
using \code{~ g1 * g2} and nested hierarchies are specified using \code{~ parent / child}.
Mixtures of the two formulations are also possible, like \code{~ g1 * (grandparent / parent / child)}.}

\item{data}{A dataset in which each column contains the values of the variables in the formula
and each row identifies a bottom level time series.}

\item{sep}{Character to separate the names of the aggregated series (\emph{default} is \code{"_"}).}

\item{sparse}{Option to return sparse matrix (\emph{default} is \code{TRUE}).}

\item{top_label}{Label of the top level variable (\emph{default} is \code{"Total"}).}
}
\value{
A (\code{na x nb}) matrix.
}
\description{
This function allows the user to easily build the (\code{na x nb}) cross-sectional
(contemporaneous) matrix mapping the \code{nb} bottom level series into the \code{na} higher level
ones. (Experimental version)
}
\examples{
## Balanced hierarchy
#         T
#    |--------|
#    A        B
#  |---|   |--|--|
# AA   AB  BA BB BC
# Names of the bottom level variables
data_bts <- data.frame(X1 = c("A", "A", "B", "B", "B"),
                       X2 = c("A", "B", "A", "B", "C"),
                       stringsAsFactors = FALSE)
# Cross-sectional aggregation matrix
C <- Cmatrix(~ X1 / X2, data_bts, sep = "")

## Unbalanced hierarchy (1)
#             T
#    |--------|------|
#    A        B      C
#  |---|   |--|--|
# AA   AB  BA BB BC
# Names of the bottom level variables
data_bts <- data.frame(X1 = c("A", "A", "B", "B", "B", "C"),
                       X2 = c("A", "B", "A", "B", "C", NA),
                       stringsAsFactors = FALSE)
# Cross-sectional aggregation matrix
C <- Cmatrix(~ X1 / X2, data_bts, sep = "")

## Unbalanced hierarchy (2)
#                 T
#       |---------|---------|
#       A         B         C
#     |---|     |---|     |---|
#    AA   AB   BA   BB   CA   CB
#  |----|         |----|
# AAA  AAB       BBA  BBB
# Names of the bottom level variables
data_bts <- data.frame(X1 = c("A", "A", "A", "B", "B", "B", "C", "C"),
                       X2 = c("A", "A", "B", "A", "B", "B", "A", "B"),
                       X3 = c("A", "B", NA, NA, "A", "B", NA, NA),
                       stringsAsFactors = FALSE)
# Cross-sectional aggregation matrix
C <- Cmatrix(~ X1 / X2 / X3, data_bts, sep = "")

## Grouped hierarchy
#         C               S
#    |--------|      |--------|
#    A        B      M        F
#  |---|    |---|
# AA   AB  BA   BB
# Names of the bottom level variables
data_bts <- data.frame(X1 = c("A", "A", "B", "B", "A", "A", "B", "B"),
                       X2 = c("A", "B", "A", "B", "A", "B", "A", "B"),
                       Y1 = c("M", "M", "M", "M", "F", "F", "F", "F"),
                       stringsAsFactors = FALSE)
# Cross-sectional aggregation matrix
C <- Cmatrix(~ Y1 * (X1 / X2), data_bts, sep = "")

}
