% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oct_bounds.R
\name{oct_bounds}
\alias{oct_bounds}
\title{Optimal cross-temporal bounds}
\usage{
oct_bounds(hts_bounds, thf_bounds, m, C, Ut)
}
\arguments{
\item{hts_bounds}{(\mjseqn{n \times 2}) matrix with cross-sectional bounds:
the first column is the lower bound, and the second column is the upper bound.}

\item{thf_bounds}{(\mjseqn{(k^\ast + m) \times 2}) matrix with temporal bounds:
the first column is the lower bound, and the second column is the upper bound.}

\item{m}{Highest available sampling frequency per seasonal cycle (max. order
of temporal aggregation, \mjseqn{m}), or a subset of \mjseqn{p} factors
of \mjseqn{m}.}

\item{C}{(\mjseqn{n_a \times n_b}) cross-sectional (contemporaneous) matrix
mapping the bottom level series into the higher level ones.}

\item{Ut}{Zero constraints cross-sectional (contemporaneous) kernel matrix
\mjseqn{(\mathbf{U}'\mathbf{y} = \mathbf{0})} spanning the null space valid
for the reconciled forecasts. It can be used instead of parameter
\code{C}, but \code{nb} (\mjseqn{n = n_a + n_b}) is needed if
\mjseqn{\mathbf{U}' \neq [\mathbf{I} \ -\mathbf{C}]}{}. If the hierarchy
admits a structural representation, \mjseqn{\mathbf{U}'} has dimension
(\mjseqn{n_a \times n}).}
}
\value{
A matrix with the cross-temporal bounds.
}
\description{
\loadmathjax
Function to export the constraints designed for the cross-sectional and/or
temporal reconciled forecasts
}
\examples{
data(FoReco_data)
# monthly base forecasts
mbase <- FoReco2matrix(FoReco_data$base, m = 12)$k1
# monthly residuals
mres <- FoReco2matrix(FoReco_data$res, m = 12)$k1

# For example, in FoReco_data we want that BA > 78, and C > 50
cs_bound <- matrix(c(rep(-Inf, 5), 78, -Inf, 50, rep(+Inf, 8)), ncol = 2)
## Cross-sectional reconciliation
csobj <- htsrec(mbase, C = FoReco_data$C, comb = "shr", res = mres, bounds = cs_bound)

# Extension of the constraints to the cross-temporal case
ct_bound <- oct_bounds(hts_bounds = cs_bound, m = 12)
## Cross-temporal reconciliation
obj <- octrec(FoReco_data$base, m = 12, C = FoReco_data$C, comb = "bdshr",
              res = FoReco_data$res, bounds = ct_bound)

}
\seealso{
Other utilities: 
\code{\link{Cmatrix}()},
\code{\link{FoReco2ts}()},
\code{\link{agg_ts}()},
\code{\link{arrange_hres}()},
\code{\link{commat}()},
\code{\link{ctf_tools}()},
\code{\link{hts_tools}()},
\code{\link{lcmat}()},
\code{\link{residuals_matrix}()},
\code{\link{score_index}()},
\code{\link{shrink_estim}()},
\code{\link{thf_tools}()}
}
\concept{utilities}
\keyword{utilities}
