% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot.R
\name{csboot}
\alias{csboot}
\title{Cross-sectional joint block bootstrap}
\usage{
csboot(model_list, boot_size, block_size, seed = NULL)
}
\arguments{
\item{model_list}{A list of all the \eqn{n} base forecasts models. A \code{simulate()}
function for each model has to be available and implemented according to the
package \href{https://CRAN.R-project.org/package=forecast}{\pkg{forecast}},
with the following mandatory parameters: \emph{object},
\emph{innov}, \emph{future}, and \emph{nsim}.}

\item{boot_size}{The number of bootstrap replicates.}

\item{block_size}{Block size of the bootstrap, which is typically equivalent
to the forecast horizon.}

\item{seed}{An integer seed.}
}
\value{
A list with two elements: the seed used to sample the errors and a 3-d array
(\eqn{\text{boot\_size}\times n \times \text{block\_size}}).
}
\description{
Joint block bootstrap for generating probabilistic base forecasts that take into account
the correlation between different time series (Panagiotelis et al. 2023).
}
\references{
Panagiotelis, A., Gamakumara, P., Athanasopoulos, G. and Hyndman, R.J. (2023),
Probabilistic forecast reconciliation: Properties, evaluation and score optimisation,
\emph{European Journal of Operational Research} 306(2), 693–706.
\doi{http://dx.doi.org/10.1016/j.ejor.2022.07.040}
}
\seealso{
Bootstrap samples: 
\code{\link{ctboot}()},
\code{\link{teboot}()}

Cross-sectional framework: 
\code{\link{csbu}()},
\code{\link{cscov}()},
\code{\link{cslcc}()},
\code{\link{csmo}()},
\code{\link{csrec}()},
\code{\link{cstd}()},
\code{\link{cstools}()}
}
\concept{Bootstrap samples}
\concept{Framework: cross-sectional}
