% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ArrayData

%Two new commands to help with formatting
\newcommand{\methodtable}{\bold{\cr #1 \cr} \tabular{lcl}}
\newcommand{\methoditem}{\emph{#1} \tab-\tab #2\cr}
\newcommand{\methodname}{\subsection{#1}}
\docType{class}
\name{ArrayData}
\alias{ArrayData}
\title{ArrayData}
\description{An abstract class for storing data in the form of an \code{n}- dimensional array.  It enforces core functionality that we want the data we model to have.  This class covers any data which has two major axis, but has more minor axis.}
\seealso{
Inherits from : \code{\link{MatrixData}}

Is inherited by : \code{\link{AbstractIncidenceArray}}, \code{\link{AbstractSimulatedIncidenceMatrix}}, \code{\link{FrameData}}}
\examples{
SampleArrayData <- R6Class(
  inherit = ArrayData,
  public = list(
    initialize = function(data)\{
      if('array' \%in\% class(data))\{
        private$.arr = data
        private$.dims = dim(data)
        private$.ndim = length(private$.dim)
        private$.dnames = dimnames(data)
      \}
    \}
  )
)
}
\section{Fields}{
\describe{
\item{arr}{This is the full array.  For extensibility, it cannot be written to directly and must be modified through methods.}
\item{cellData}{A list of metadata associated with the cells of the data.}
\item{cnames}{The names of columns in the data.}
\item{colData}{A list of metadata associated with the columns of the data.}
\item{dimData}{The data associated with each dimension of the array.}
\item{dims}{The size of the array.}
\item{dnames}{The size of the array.}
\item{mat}{This is the matrix.  For extensibility, it cannot be written to directly and must be modified through methods.}
\item{metaData}{Any data not part of the main data structure.}
\item{ncol}{The number of columns in the data.}
\item{ndim}{The number of dimensions of the array.}
\item{nrow}{The number of rows in the data}
\item{rnames}{The names of rows in the data.}
\item{rowData}{A list of metadata associated with the rows of the data.}
}}
\section{Methods}{
\methodname{debug(string)}{
A function for debugging the methods of this class.  It calls the \link{browser} command.  In order for methods to opt into to debugging, they need to implement the following code at the beginning: if(<method_name> \%in\% private$.debug)\{browser()\}.  This method exists, because the debugger is not always intuitive when it comes to debugging R6 methods.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{string}{The name(s) of methods to debug as a character vector}
}}}}
\methodname{initialize(...)}{
This function \bold{should} be extended. Create a new instance of this class.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{\dots}{This function should take in any arguments just in case.}
}}}}
\methodname{undebug(string)}{
A function for ceasing to debug methods.  Normally a method will call the \link{browser} command every time it is run.  This command will stop it from doing so.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{string}{The name(s) of the methods to stop debugging.}
}}}}
}
