% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AbstractIncidenceArray

%Two new commands to help with formatting
\newcommand{\methodtable}{\bold{\cr #1 \cr} \tabular{lcl}}
\newcommand{\methoditem}{\emph{#1} \tab-\tab #2\cr}
\newcommand{\methodname}{\subsection{#1}}
\docType{class}
\name{AbstractIncidenceArray}
\alias{AbstractIncidenceArray}
\title{AbstractIncidenceArray}
\description{An abstract class for storing an array.  It has an array of data arr, which it is responsible for storing.  For arrays with particular metadata, consider extending this class.  However, if the class is not truly an array, consider extending FrameData.}
\seealso{
Inherits from : \code{\link{ArrayData}}

}
\examples{
require(abind)
SampleIncidenceArray  <- R6Class(
  inherit= AbstractIncidenceArray,
  public = list(
    initialize = function(data,dims = dim(data),dnames,dimData,metaData)\{
      private$.arr <- array(data,dims)
      if(!missing(dnames))\{
        dimnames(private$.arr) <- dnames
        private$.dnames <- dnames
      \}
      private$.dims = dim(data)
      private$.ndim = length(dim(data))
      if(!missing(dimData))\{
        self$dimData <- dimData
      \} else \{
        self$dimData <- rep(list(list()),self$ndim)
      \}
      if(!missing(metaData))\{
        self$metaData <- metaData
      \}
    \},
    addSlices = function(number,dimension,mutate=TRUE)\{
      if(!mutate)\{
        return(self$clone(TRUE)$addSlices(number,dimension))
      \}
      dims <- private$.dims
      dims[dimension] <- number
      private$.arr <-
        abind(
          private$.arr,
          array(NA,dims),
          along=dimension
        )
      private$.dims = dim(private$.arr)
      private$.dnames = dimnames(private$.arr)
    \},
    subset = function(...,mutate=TRUE)\{
      if(!mutate)\{
        return(self$clone(TRUE)$subset(number,dimension))
      \}
      private$.arr = private$.arr[...]
      private$.dnames = dimnames(private$.arr)
      private$.dims = dim(private$.arr)
      self$dimData <- 
        mapply(
          index = list(...),
          obj = self$dimData,
          function(index,obj)\{
            lapply(obj,function(x)\{x[index]\})
          \},
          SIMPLIFY = FALSE
        )
    \}
  )
)

data = SampleIncidenceArray$new(array(1:27,c(3,3,3)))
data$addSlices(1,1)
data$addSlices(2,2)
data$addSlices(3,3)
data$arr
data$dims
data$subset(1:2,1:2,1:2)
}
\section{Fields}{
\describe{
\item{arr}{This is the full array.  For extensibility, it cannot be written to directly and must be modified through methods.}
\item{cellData}{A list of metadata associated with the cells of the data.}
\item{cnames}{The names of columns in the data.}
\item{colData}{A list of metadata associated with the columns of the data.}
\item{dimData}{The data associated with each dimension of the array.}
\item{dims}{The size of the array.}
\item{dnames}{The size of the array.}
\item{mat}{This is the matrix.  For extensibility, it cannot be written to directly and must be modified through methods.}
\item{metaData}{Any data not part of the main data structure.}
\item{ncol}{The number of columns in the data.}
\item{ndim}{The number of dimensions of the array.}
\item{nrow}{The number of rows in the data}
\item{rnames}{The names of rows in the data.}
\item{rowData}{A list of metadata associated with the rows of the data.}
}}
\section{Methods}{
\methodname{addSlices(number,dimension=2,mutate=TRUE)}{
This method \bold{must} be extended.  Extend a dimension by adding extra indices to the end.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{number}{How many slices to add.}
\methoditem{dimension}{Which dimension should slices be added to.}
\methoditem{mutate}{Whether to change the original instance, or create a new one.  If FALSE, the instance performing the method will be left unchanged, and a modified copy will be returned.  If true, then the instance will modify itself and return nothing.}
}}
\item{Value}{If \code{mutate=FALSE}, a clone of this object will run the method and be returned.  Otherwise, there is no return.}
}}
\methodname{apply(FUNC,dimension=c(1,2))}{
This method \bold{must} be extended.  Apply a function to each slice.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{FUNC}{The function to apply}
\methoditem{dimension}{The dimension(s) to hold fixed.}
}}
\item{Value}{An IncidenceArray with dimension equal to \code{self$dims[dimension]}}
}}
\methodname{debug(string)}{
A function for debugging the methods of this class.  It calls the \link{browser} command.  In order for methods to opt into to debugging, they need to implement the following code at the beginning: if(<method_name> \%in\% private$.debug)\{browser()\}.  This method exists, because the debugger is not always intuitive when it comes to debugging R6 methods.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{string}{The name(s) of methods to debug as a character vector}
}}}}
\methodname{initialize(...)}{
This function \bold{should} be extended. Create a new instance of this class.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{\dots}{This function should take in any arguments just in case.}
}}}}
\methodname{subset(...,mutate=TRUE)}{
This method \bold{must} be extended.  Take a subset of the matrix.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{\dots}{dimensional indices in order.}
\methoditem{mutate}{Whether to modify the existing object, or return a modified copy.}
}}
\item{Value}{If \code{mutate=FALSE}, a clone of this object will run the method and be returned.  Otherwise, there is no return.}
}}
\methodname{undebug(string)}{
A function for ceasing to debug methods.  Normally a method will call the \link{browser} command every time it is run.  This command will stop it from doing so.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{string}{The name(s) of the methods to stop debugging.}
}}}}
}
