% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fe_species_bavrn_state_short.R
\name{as_fe_species_bavrn_state_short}
\alias{as_fe_species_bavrn_state_short}
\title{Cast Appropriate Objects Into a \strong{fe_stand_bavrn_state_short} Species Class
Object}
\usage{
as_fe_species_bavrn_state_short(x)
}
\arguments{
\item{x}{The object to be cast, either a vector of types \code{integer},
\code{double}, or \code{character} or an object of one of the supported
\strong{fe_species} classes}
}
\value{
If a meaningful cast is possible, an
\code{fe_species_bavrn_state_short} object is returned
}
\description{
If the cast is forward ambiguous, the function terminates with an error.
"Forward ambiguous" means that one code in the original object corresponds to
more than one codes in the goal coding. If the cast loses information, a
warning is raised, but the cast is performed. "Information loss" in this
context means that several codes from the orginal coding correspond to only
one code in the goal coding.
}
\details{
Note that a cast where only one species id from the original coding
translates in a goal coding which represents a group of species is NOT
considered losing information (i.e. backward ambiguous), because of the 1:1
match in the constellation of the specific cast.
}
\examples{
as_fe_species_bavrn_state_short(c(1L, 4L, 4L, 2L)) # integer
as_fe_species_bavrn_state_short(c(1, 4, 4, 2)) # double
as_fe_species_bavrn_state_short(c("1", "4", "4", "2")) # character

# cast other fe_species classes
as_fe_species_bavrn_state_short(
  fe_species_tum_wwk_short(as.character(c(1, 1, 1, 3, 3, 5)))
)
as_fe_species_bavrn_state_short(
  fe_species_ger_nfi_2012(as.character(c(20, 20, 10, 30, 30, 100)))
)

# display the casting result in terms of scientific species names
as_fe_species_bavrn_state_short(c(1L, 4L, 4L, 2L)) |> format("sci")

}
