% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SegmentCrowns.R
\name{SegmentCrowns}
\alias{SegmentCrowns}
\title{SegmentCrowns}
\usage{
SegmentCrowns(treetops, CHM, minHeight = 0, maxCells = 2e+06,
  tileBuffer = 20)
}
\arguments{
\item{treetops}{\link[sp]{SpatialPointsDataFrame}. The point locations of treetops. The function will generally produce a
number of crown segments equal to the number of treetops.}

\item{CHM}{Canopy height model. Either in \link[raster]{raster} format, or a path directing to a raster file. A character vector of multiple paths directing to a
tiled raster dataset can also be used.}

\item{minHeight}{numeric. The minimum height value for a \code{CHM} pixel to be considered as part of a crown segment.
All \code{CHM} pixels beneath this value will be masked out. Note that this value should be lower than the minimum
height of \code{treetops}.}

\item{maxCells}{numeric. If the number of raster cells for the \code{CHM} exceeds this value, the \link[TileManager]{TileScheme} function
will be applied to break apart the input into tiles to speed up processing.}

\item{tileBuffer}{numeric. If the function breaks the CHM into tiles for processing, an
overlapping spatial buffer is applied around each tile to prevent edge effects. The
\code{tileBuffer} argument defines the width of this buffer, and should be equal to half
the diameter of the widest expected tree crown.}
}
\value{
A \link[raster]{raster} of crown segments. The \link[raster]{rasterToPolygons} function can be used to convert this into
polygons.
}
\description{
Implements the \link[imager]{watershed} function to segment crowns from a canopy height model. Segmentation is
guided by the point locations of treetops, typically detected using the \link{TreeTopFinder} function. See Meyer
& Beucher (1990) for details on watershed segmentation.
}
\examples{
# Use TreeTopFinder to detect treetops in demo canopy height model
ttops <- TreeTopFinder(CHMdemo, winFun = function(x){x * 0.06 + 0.5}, minHeight = 2)

# Set minimum tree crown height (should be LOWER than minimum treetop height)
minCrwnHgt <- 1

# Use SegmentCrowns to outline tree crowns
segs <- SegmentCrowns(ttops, CHMdemo, minCrwnHgt)
}
\references{
Meyer, F., & Beucher, S. (1990). Morphological segmentation. Journal of visual communication and image representation, 1(1), 21-46.
}
\seealso{
\code{\link{TreeTopFinder}}  \code{\link[imager]{watershed}}
}

