\name{Class design and accessors}
\alias{design}
\alias{desnum}
\alias{run.order}
\alias{design.info}

%- Also NEED an '\alias' for EACH other topic documented here.
\title{ ~~ Internal utility functions and user-visible constants for working with regular fractional factorials ~~ }
\description{
  ~~ Internal functions, mainly for deriving words, alias structures and so forth from catalogue information for regular 2-level fractional factorials. 
  They need not be accessed for normal use of the package - some of them may be made user-usable for future versions of the package. 
  
  The constants Yates and Letters are user-visible, as they can be useful for expert users. ~~
}
\usage{
desnum(design)
run.order(design)
design.info(design)
design
}
\arguments{
  \item{design}{ data frame of class design as generated by \code{FrF2}, \code{pb}, or \code{fac.design} }
}
\details{
    Items of class \code{design} are data frames with attributes. 
    The function extract the respective attribute, i.e. e.g. function design.info 
    extracts the design information for the design, which depends on the way the 
    design was obtained.
}
\value{
    \code{desnum} returns a numeric matrix,
    \code{run.order} returns a 2-column matrix with standard and actual run order,
    \code{design.info} returns a list with first element \code{type}, 
        further info on the design, and some options of the design call regarding 
        randomization and replication
}
\references{ 
  Hedayat, A.S., Sloane, N.J.A. and Stufken, J. (1999) \emph{Orthogonal Arrays: Theory and Applications}, Springer, New York. 
}
\author{ Ulrike Groemping }
\note{ This package is currently under intensive development. Substantial changes are to be expected in the near future.}
\seealso{ ~~See Also \code{\link{FrF2}}, \code{\link{pb}}, \code{\link{fac.design}} }
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ array }
\keyword{ design }% __ONLY ONE__ keyword per line
