% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frechetpc.R
\name{pred.FT}
\alias{pred.FT}
\title{Frechet Tree prediction}
\usage{
pred.FT(tree, X, time, id, timeScale = 0.1)
}
\arguments{
\item{tree}{: Frechet tree obtained with the function \code{\link{FrechTree}}.}

\item{X}{[matrix]: a data frame or a matrix of trajectories predictors.}

\item{time}{[vector]: time measurements of the new trajectories to predict.}

\item{id}{[vector]: identifier, one for each trajectory to attribute each measurement of \code{X} to one of the trajectories.}

\item{timeScale}{[numeric]: allow to modify the time scale, increasing or decreasing the cost of the horizontal shift. If timeScale is very big, then the Frechet mean tends to the Euclidean distance. If timeScale is very small, then it tends to the Dynamic Time Warping.}
}
\value{
a vector of the identifier of the leaf in which each observation falls.
}
\description{
Given a Frechet tree and new input trajectories predictors \code{X}, this function returns the identifier of the leaf in which each observation falls.
}
\keyword{internal}
