% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_plot.R
\name{draw_plot}
\alias{draw_plot}
\title{Funnel Plots drawing function}
\usage{
draw_plot(
  mod_plot_agg,
  limits,
  x_label,
  y_label,
  title,
  label_outliers,
  multiplier,
  Poisson_limits,
  OD_adjust,
  target,
  min_y,
  max_y,
  min_x,
  max_x,
  data_type,
  sr_method,
  theme,
  plot_cols
)
}
\arguments{
\item{mod_plot_agg}{data.frame of containing numerator, denominator, ratio/proportion, SEs and limits}

\item{limits}{data.frame of limits from set_plot_range().}

\item{x_label}{Title for the funnel plot x-axis.  Usually expected deaths, readmissions, incidents etc.}

\item{y_label}{Title for the funnel plot y-axis.  Usually a standardised ratio.}

\item{title}{Plot title}

\item{label_outliers}{Add group labels to outliers on plot. Accepted values are\: 95 or 99 corresponding to 95\% or 99.8\% quantiles of the distribution. Default=99}

\item{multiplier}{Scale relative risk and funnel by this factor. Default to 1, but 100 is used for HSMR}

\item{Poisson_limits}{Draw exact limits based only on data points with no iterpolation. (default=FALSE)}

\item{OD_adjust}{Draw overdispersed limits using Spiegelhalter's (2012) tau2 (default=TRUE)}

\item{target}{the calculated target value for the data type}

\item{min_y}{Specify the plot range.}

\item{max_y}{Specify the plot range.}

\item{min_x}{Specify the plot range.}

\item{max_x}{Specify the plot range.}

\item{data_type}{the data type SR, PR or RC.}

\item{sr_method}{CQC or SHMI methods for standardised ratios}

\item{theme}{a ggplot theme function.}
}
\value{
A list containing [1] the funnel plot as a ggplot2 object., [2]the limits table.
}
\description{
Internal function for drawing plot.  Do not use this directly, call `funnel_plot()` instead.
}
\keyword{internal}
