% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-02-PiecewiseLinearFuzzyNumber.R
\docType{class}
\name{PiecewiseLinearFuzzyNumber-class}
\alias{PiecewiseLinearFuzzyNumber-class}
\title{S4 Class Representing a Piecewise Linear Fuzzy Number}
\description{
A piecewise linear fuzzy number (PLFN) has side functions
and alpha-cut bounds that linearly interpolate a given set of points
(at fixed alpha-cuts).
}
\details{
If \code{knot.n} is equal to 0 or all left and right knots lie on common lines,
then a Piecewise Linear Fuzzy Number reduces to a
\linkS4class{TrapezoidalFuzzyNumber}.
Note that, however, the
\code{\linkS4class{TrapezoidalFuzzyNumber}} does not inherit from
\code{\linkS4class{PiecewiseLinearFuzzyNumber}} for efficiency reasons.
To convert the former to the latter, call \code{\link{as.PiecewiseLinearFuzzyNumber}}.
}
\section{Slots}{

 \describe{
   \item{\code{a1}, \code{a2}, \code{a3}, \code{a4},
   \code{lower}, \code{upper}, \code{left}, \code{right}:}{
   Inherited from the \code{\linkS4class{FuzzyNumber}} class.}
    \item{\code{knot.n}:}{number of knots, a single integer value,
    0 for a trapezoidal fuzzy number}
    \item{\code{knot.alpha}:}{alpha-cuts, increasingly sorted vector of length \code{knot.n} with elements in [0,1]}
    \item{\code{knot.left}:}{nondecreasingly sorted vector of length \code{knot.n};
    defines left alpha-cut bounds at knots}
    \item{\code{knot.right}:}{nondecreasingly sorted vector of length \code{knot.n};
    defines right alpha-cut bounds at knots}
 }
}

\section{Extends}{

Class \code{\linkS4class{FuzzyNumber}}, directly.
}
\examples{
showClass("PiecewiseLinearFuzzyNumber")
showMethods(classes="PiecewiseLinearFuzzyNumber")
}
\seealso{
\code{\link{PiecewiseLinearFuzzyNumber}} for a convenient constructor,
\code{\link{as.PiecewiseLinearFuzzyNumber}} for conversion of objects to this class,
and \code{\link{piecewiseLinearApproximation}} for approximation routines.

Other PiecewiseLinearFuzzyNumber-method: \code{\link{Arithmetic}},
  \code{\link{PiecewiseLinearFuzzyNumber}},
  \code{\link{^,PiecewiseLinearFuzzyNumber,numeric-method}},
  \code{\link{alphaInterval}}, \code{\link{arctan2}},
  \code{\link{as.PiecewiseLinearFuzzyNumber}},
  \code{\link{as.PowerFuzzyNumber}},
  \code{\link{as.TrapezoidalFuzzyNumber}},
  \code{\link{as.character}},
  \code{\link{expectedInterval}}, \code{\link{fapply}},
  \code{\link{maximum}}, \code{\link{minimum}},
  \code{\link{necessityExceedance}},
  \code{\link{necessityStrictExceedance}},
  \code{\link{necessityStrictUndervaluation}},
  \code{\link{necessityUndervaluation}},
  \code{\link{plot}}, \code{\link{possibilityExceedance}},
  \code{\link{possibilityStrictExceedance}},
  \code{\link{possibilityStrictUndervaluation}},
  \code{\link{possibilityUndervaluation}}
}

