% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VAAmethod.R
\name{VAAmethod}
\alias{VAAmethod}
\title{V(alue)A(mbiguity, left-hand)A(mbiguity, right-hand) resampling method for triangular and trapezoidal fuzzy numbers}
\usage{
VAAmethod(initialSample, b = n, increases = FALSE)
}
\arguments{
\item{initialSample}{Initial sample of triangular or trapezoidal fuzzy numbers.}

\item{b}{The number of fuzzy values in the resampled (secondary) sample.
If this parameter is not specified, the number of values in the initial sample is used.
The parameter should be integer value more than 0.}

\item{increases}{If \code{TRUE} is used, then the initial sample should consist of the fuzzy numbers in the form:
left increment of the support, left end of the core, right end of the core,
right increment of the support. Otherwise, the default value \code{FALSE} is used and the fuzzy numbers should be given in the form:
left end of the support, left end of the core, right end of the core,
right end of the support.}
}
\value{
This function returns matrix with \code{b} rows of double values.
In each row, there is a single resampled fuzzy number.
These fuzzy numbers have the same form as the values from the initial sample depending on the provided parameter \code{increases}.
}
\description{
\code{VAAmethod} returns the secondary (bootstrapped) sample and uses the resampling
scheme which does not change the values, left-hand and right-hand ambiguities of the fuzzy variables from
the initial sample (the VAA method, see (Grzegorzewski and Romaniuk, 2021)).
}
\details{
The initial sample should consist of triangular or trapezoidal fuzzy numbers, given as a single vector or a whole matrix.
In each row, there should be a single fuzzy number in one of the forms:
\enumerate{
\item left end of the support, left end of the core, right end of the core, right end of the support, or
\item left increment of the support, left end of the core, right end of the core, right increment of the support.
}
In this second case, the parameter \code{increases=TRUE} has to be used.

The resampling procedure produces \code{b} fuzzy values.
During the first step, the fuzzy value from the initial sample is randomly chosen (with repetition).
Then the new fuzzy variable, which preserves the value, left- and right-hand ambiguities of the old one, is randomly created.
If the parameter \code{b} is not specified, it is equal to the length of the initial sample.
The output is given in the same form as the initial sample.
}
\examples{

# prepare some fuzzy numbers (first type of the initial sample)

fuzzyValues <- matrix(c(0.25,0.5,1,1.25,0.75,1,1.5,2.2,-1,0,0,2),
ncol = 4,byrow = TRUE)

# generate the secondary sample using the VAA method

set.seed(12345)

VAAmethod(fuzzyValues)

VAAmethod(fuzzyValues,b=4)

# prepare some fuzzy numbers (second type of the initial sample)

fuzzyValuesInc <- matrix(c(0.25,0.5,1,0.25,0.25,1,1.5,0.7,1,0,0,2),
ncol = 4,byrow = TRUE)

# generate the secondary sample using the VAA method

VAAmethod(fuzzyValuesInc,increases = TRUE)

VAAmethod(fuzzyValuesInc,b=4,increases = TRUE)

}
\references{
Grzegorzewski, P., Romaniuk, M. (2021)
Bootstrap methods for fuzzy data
(to be published)
}
\seealso{
@seealso \code{\link{classicalBootstrap}},
\code{\link{EWmethod}} for the EW method, \code{\link{VAFmethod}} for the VAF method,
\code{\link{dmethod}} for the d method, \code{\link{wmethod}} for the w method

Other resampling functions: 
\code{\link{EWmethod}()},
\code{\link{VAFmethod}()},
\code{\link{VAmethod}()},
\code{\link{classicalBootstrap}()},
\code{\link{dmethod}()},
\code{\link{wmethod}()}
}
\concept{resampling functions}
