% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_genes_qtls_around_markers.R
\name{find_genes_qtls_around_markers}
\alias{find_genes_qtls_around_markers}
\title{Search genes and QTLs around candidate regions}
\usage{
find_genes_qtls_around_markers(
  db_file,
  marker_file,
  method = c("gene", "qtl"),
  marker = c("snp", "haplotype"),
  interval = 0,
  nThreads = NULL,
  verbose = TRUE
)
}
\arguments{
\item{db_file}{The dataframe obtained using the import_gff_gtf() function}

\item{marker_file}{The file with the SNP or haplotype positions. Detail: For SNP files, the columns “CHR” and “BP” with the chromosome and base pair position, respectively, are mandatory. For the haplotype, the following collumns are mandatory: “CHR”, “BP1” and “BP2”}

\item{method}{“gene” or “qtl”}

\item{marker}{"snp" or "haplotype"}

\item{interval}{The interval in base pair which can be included upstream and downstream from the markers or haplotype coordinates.}

\item{nThreads}{Number of threads to be used}

\item{verbose}{Logical value defining if messages should of not be printed during the analysis (default=TRUE)}
}
\value{
A dataframe with the genes or QTLs mapped within the specified intervals
}
\description{
Takes a list of candidate markers and or regions (haplotypes, CNVs, windows, etc.) and search for genes or QTLs in a determined interval
}
\examples{
data(QTLmarkers)
data(gffQTLs)
out.qtls<-find_genes_qtls_around_markers(db_file=gffQTLs,
marker_file=QTLmarkers, method = "qtl",
marker = "snp", interval = 500000, nThreads = NULL)
}
