# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @rdname gcsm
#' @export
cmsc <- function(x, y, rescale = FALSE, xmin = NA_real_, xmax = NA_real_, ymin = NA_real_, ymax = NA_real_, comp = "si") {
    .Call(`_GCSM_cmsc`, x, y, rescale, xmin, xmax, ymin, ymax, comp)
}

#' @rdname gcsm_sw
#' @export
cmsc_sw <- function(x, y, rescale = FALSE, xmin = NA_real_, xmax = NA_real_, ymin = NA_real_, ymax = NA_real_, ksize = 9, globe = FALSE, comp = "si") {
    .Call(`_GCSM_cmsc_sw`, x, y, rescale, xmin, xmax, ymin, ymax, ksize, globe, comp)
}

#' @rdname gcsm_tw
#' @export
cmsc_tw <- function(xxx, yyy, rescale = FALSE, xmin = NA_real_, xmax = NA_real_, ymin = NA_real_, ymax = NA_real_, comp = "si") {
    .Call(`_GCSM_cmsc_tw`, xxx, yyy, rescale, xmin, xmax, ymin, ymax, comp)
}

#' @rdname gcsm
#' @export
cmsc_e1 <- function(x, y, rescale = FALSE, xmin = NA_real_, xmax = NA_real_, ymin = NA_real_, ymax = NA_real_, comp = "si") {
    .Call(`_GCSM_cmsc_e1`, x, y, rescale, xmin, xmax, ymin, ymax, comp)
}

#' @rdname gcsm_sw
#' @export
cmsc_e1_sw <- function(x, y, rescale = FALSE, xmin = NA_real_, xmax = NA_real_, ymin = NA_real_, ymax = NA_real_, ksize = 9, globe = FALSE, comp = "si") {
    .Call(`_GCSM_cmsc_e1_sw`, x, y, rescale, xmin, xmax, ymin, ymax, ksize, globe, comp)
}

#' @rdname gcsm_tw
#' @export
cmsc_e1_tw <- function(xxx, yyy, rescale = FALSE, xmin = NA_real_, xmax = NA_real_, ymin = NA_real_, ymax = NA_real_, comp = "si") {
    .Call(`_GCSM_cmsc_e1_tw`, xxx, yyy, rescale, xmin, xmax, ymin, ymax, comp)
}

#' @rdname gcsm
#' @export
cmsc_e2 <- function(x, y, rescale = FALSE, xmin = NA_real_, xmax = NA_real_, ymin = NA_real_, ymax = NA_real_, comp = "si") {
    .Call(`_GCSM_cmsc_e2`, x, y, rescale, xmin, xmax, ymin, ymax, comp)
}

#' @rdname gcsm_sw
#' @export
cmsc_e2_sw <- function(x, y, rescale = FALSE, xmin = NA_real_, xmax = NA_real_, ymin = NA_real_, ymax = NA_real_, ksize = 9, globe = FALSE, comp = "si") {
    .Call(`_GCSM_cmsc_e2_sw`, x, y, rescale, xmin, xmax, ymin, ymax, ksize, globe, comp)
}

#' @rdname gcsm_tw
#' @export
cmsc_e2_tw <- function(xxx, yyy, rescale = FALSE, xmin = NA_real_, xmax = NA_real_, ymin = NA_real_, ymax = NA_real_, comp = "si") {
    .Call(`_GCSM_cmsc_e2_tw`, xxx, yyy, rescale, xmin, xmax, ymin, ymax, comp)
}

#' Composite similarity between vectors
#'
#' Compute composite measures, GCSM or CMSC, between two vectors.
#'
#' These functions compute composite measures between vectors. Missing values
#' are omitted. Normalization parameters are used to rescale `x` and `y`, and
#' determine the global minimum (min) and maximum (max). If `rescale` is
#' `TRUE`, `x` and `y` are rescaled to `(x-xmin)/(xmax-xmin)` and
#' `(y-ymin)/(ymax-ymin)`; and set `min=0`, `max=1`. If `FALSE`,
#' `min=min(xmin,ymin)`, `max=max(xmax,ymax)`.
#' @param x A vector.
#' @param y The other vector.
#' @param rescale Rescale or not before computation.
#' @param xmin,xmax,ymin,ymax Normalization parameters. If `NA`, are calculated
#'   from the ranges of `x` and `y`, respectively. See Details.
#' @param comp Variable to return. If `"si"`, the composite measure, if
#'   `"s1"`,`"s2"` or `"s3"`, the corresponding component.
#' @return A number.
#' @examples
#' x = runif(9)
#' gcsm(x, x)
#' cmsc(x, x)
#' # mean shift
#' gcsm(x, x - 0.2, xmin = 0, xmax = 1, ymin = 0, ymax = 1)
#' cmsc(x, x - 0.2, xmin = 0, xmax = 1, ymin = 0, ymax = 1)
#' gcsm(x, x + 0.2, xmin = 0, xmax = 1, ymin = 0, ymax = 1)
#' cmsc(x, x + 0.2, xmin = 0, xmax = 1, ymin = 0, ymax = 1)
#' ## dissimilarity
#' y = 1 - x # y is the perfect antianalog of x
#' gcsm(y, x)
#' gcsm(y, x - 0.2, xmin = 0, xmax = 1, ymin = 0, ymax = 1)
#' gcsm(y, x + 0.2, xmin = 0, xmax = 1, ymin = 0, ymax = 1)
#'
#' # random noise
#' noise = rnorm(9, mean = 0, sd = 0.2)
#' gcsm(x, x + noise, xmin = 0, xmax = 1, ymin = 0, ymax = 1)
#' cmsc(x, x + noise, xmin = 0, xmax = 1, ymin = 0, ymax = 1)
#' ## dissimilarity
#' gcsm(y, x + noise, xmin = 0, xmax = 1, ymin = 0, ymax = 1)
#' @export
gcsm <- function(x, y, rescale = FALSE, xmin = NA_real_, xmax = NA_real_, ymin = NA_real_, ymax = NA_real_, comp = "si") {
    .Call(`_GCSM_gcsm`, x, y, rescale, xmin, xmax, ymin, ymax, comp)
}

#' Composite similarity on spatial windows
#'
#' Compute composite measures, GCSM, CMSC or SSIM, on spatial windows.
#'
#' These functions slide the spatial window over space. Missing values are
#' omitted. Normalization parameters are used to rescale `x` and `y`, and
#' determine the global minimum (min) and maximum (max). If `rescale` is
#' `TRUE`, `x` and `y` are rescaled to `(x-xmin)/(xmax-xmin)` and
#' `(y-ymin)/(ymax-ymin)`; and set `min=0`, `max=1`. If `FALSE`,
#' `min=min(xmin,ymin)`, `max=max(xmax,ymax)`. OpenMP is used for parallel
#' computing.
#' @param x A matrix.
#' @param y The other matrix.
#' @param rescale Rescale or not before computation.
#' @param xmin,xmax,ymin,ymax Normalization parameters. If `NA`, are calculated
#'   from the ranges of `x` and `y`, respectively. See Details.
#' @param ksize Side length of spatial windows.
#' @param globe Are data at the global scale? If `TRUE`, two vertical borders
#'   will be padded before computation.
#' @param comp Variable to return. If `"si"`, the composite measure, if
#'   `"s1"`,`"s2"` or `"s3"`, the corresponding component.
#' @return A matrix.
#' @examples
#' x = matrix(runif(36), nrow = 6, ncol = 6)
#'
#' gcsm_sw(x, x + 0.2, xmin = 0, xmax = 1, ymin = 0, ymax = 1, ksize = 3)
#' cmsc_sw(x, x + 0.2, xmin = 0, xmax = 1, ymin = 0, ymax = 1, ksize = 3)
#' ssim_sw(x, x + 0.2, xmin = 0, xmax = 1, ymin = 0, ymax = 1, ksize = 3)
#' @export
gcsm_sw <- function(x, y, rescale = FALSE, xmin = NA_real_, xmax = NA_real_, ymin = NA_real_, ymax = NA_real_, ksize = 9, globe = FALSE, comp = "si") {
    .Call(`_GCSM_gcsm_sw`, x, y, rescale, xmin, xmax, ymin, ymax, ksize, globe, comp)
}

#' Composite similarity on temporal windows
#'
#' Compute composite measures, GCSM or CMSC, on temporal windows.
#'
#' These functions slide the temporal window over space. Missing values are
#' omitted. Normalization parameters are used to rescale `xxx` and `yyy`, and
#' determine the global minimum (min) and maximum (max). If `rescale` is
#' `TRUE`, `xxx` and `yyy` are rescaled to `(xxx-xmin)/(xmax-xmin)` and
#' `(yyy-ymin)/(ymax-ymin)`; and set `min=0`, `max=1`. If `FALSE`,
#' `min=min(xmin,ymin)`, `max=max(xmax,ymax)`. OpenMP is used for parallel
#' computing.
#' @param xxx A 3-d array with the 3rd dimension representing time.
#' @param yyy The other 3-d array.
#' @param rescale Rescale or not before computation.
#' @param xmin,xmax,ymin,ymax Normalization parameters. If `NA`, are calculated
#'   from the ranges of `xxx` and `yyy`, respectively. See Details.
#' @param comp Variable to return. If `"si"`, the composite measure, if
#'   `"s1"`,`"s2"` or `"s3"`, the corresponding component.
#' @return A matrix.
#' @examples
#' x = array(runif(81), dim = c(3, 3, 9))
#'
#' gcsm_tw(x, x + 0.2, xmin = 0, xmax = 1, ymin = 0, ymax = 1)
#' cmsc_tw(x, x + 0.2, xmin = 0, xmax = 1, ymin = 0, ymax = 1)
#' @export
gcsm_tw <- function(xxx, yyy, rescale = FALSE, xmin = NA_real_, xmax = NA_real_, ymin = NA_real_, ymax = NA_real_, comp = "si") {
    .Call(`_GCSM_gcsm_tw`, xxx, yyy, rescale, xmin, xmax, ymin, ymax, comp)
}

#' @rdname gcsm_sw
#' @param sigma Standard deviation of Gaussian weighting function
#' depending on the distance between the cell and kernel center.
#' @export
ssim_sw <- function(x, y, rescale = FALSE, xmin = NA_real_, xmax = NA_real_, ymin = NA_real_, ymax = NA_real_, ksize = 11, sigma = 1.5, globe = FALSE, comp = "si") {
    .Call(`_GCSM_ssim_sw`, x, y, rescale, xmin, xmax, ymin, ymax, ksize, sigma, globe, comp)
}

