% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.GCalign.R
\name{plot.GCalign}
\alias{plot.GCalign}
\title{Plot diagnostics for an GCalign Object}
\usage{
\method{plot}{GCalign}(x, which_plot = c("all", "shifts", "variation",
  "peak_numbers", "peaks_shared"), ...)
}
\arguments{
\item{x}{Object of class GCalign, created with \code{\link{align_chromatograms}}}

\item{which_plot}{A character defining which plot is created. Options are "shifts", "variation", "peak_numbers" and "peaks_shared". By default all four are created.}

\item{...}{Optional arguments passed on to methods. See
\code{\link[graphics]{plot}}, \code{\link[graphics]{hist}} and \code{\link[graphics]{barplot}}. Note that optional arguments are not passed on when plotting all figures.}
}
\value{
Depending on the selected plot a data frame containing the data source of the respective plot is returned. If all plots are created, no output will be returned.
}
\description{
Visualises the aligned data based on four diagnostic plots. One plot shows the distribution of peak numbers per sample in the raw data and after alignment. A second plot gives the distribution of linear shifts that were applied in order to conduct a full alignment of samples with respect to reference. A third sample gives a distribution of the variation in retention times of homologous peaks. The fourth plot shows a frequency distribution of peaks shared among samples.
}
\examples{
## GCalign object
data("aligned_peak_data")

## All plots are shown by default
plot(aligned_peak_data)

## Distribution of peak numbers
plot(aligned_peak_data, which_plot = "peak_numbers")

## variation of retention times
plot(aligned_peak_data, which_plot = "variation")

}
\author{
Martin Stoffel (martin.adam.stoffel@gmail.com) & Meinolf Ottensmann
 (meinolf.ottensmann@web.de)
}
