% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dif.R, R/summary.GDINA.R
\name{dif}
\alias{dif}
\alias{summary.dif}
\title{Differential item functioning for cognitive diagnosis models}
\usage{
dif(dat, Q, group, method = "wald", difitem = "all", parm = "delta",
  digits = 4, SE.type = 2, ...)

\method{summary}{dif}(object, ...)
}
\arguments{
\item{dat}{A required \eqn{N \times J} \code{matrix} or \code{data.frame} consisting of the
responses of \eqn{N} examinees to \eqn{J} items. Missing values need to be coded as \code{NA}.}

\item{Q}{A required \eqn{J \times K} item/category and attribute association matrix, wher J represents the number of
items/categories and K represents the number of attributes. For binary attributes,
1 denotes attributes are measured by items and 0 means attributes are not
necessary. For polytomous attributes, non-zero elements indicate which level
of attributes are needed. Note that for polytomous items, the sequential G-DINA
model is used and either restricted or unrestricted category-level Q-matrix is needed.
The first column represents the item number and
the second column indicates the category number. See \code{Examples}.}

\item{group}{a scalar indicating which column in \code{dat} is group indicator or
a numerical vector indicating the group each individual belongs to. If it is a vector,
its length must be equal to the number of individuals. More than two groups cannot be handled.}

\item{method}{DIF detection method; It can be \code{"wald"} for Hou, de la Torre, and Nandakumar's (2014)
Wald test method, and \code{"LR"} for likelihood ratio test.}

\item{difitem}{Items for the DIF detection. By default, all items will be examined.}

\item{parm}{The type of parameters associated with the Wald test for the DIF detection. It can be either \code{"itemprob"}
or \code{"delta"} for item probabilities and delta parameters, respectively.}

\item{digits}{How many decimal places in each number? The default is 4.}

\item{SE.type}{Type of standard error estimation methods for Wald test.}

\item{...}{arguments passed to GDINA function for model calibration}

\item{object}{estimated GDINA object for various S3 methods}
}
\value{
a data frame giving the Wald statistics and associated p-values.
}
\description{
This function is used to detect differential item functioning based on the models estimated
in the \code{\link{GDINA}} function using the Wald test (Hou, de la Torre, & Nandakumar, 2014)
}
\section{Methods (by generic)}{
\itemize{
\item \code{summary}: print summary information
}}
\examples{
\dontrun{
set.seed(123456)
N <- 1000
Q <- sim10GDINA$simQ
gs <- matrix(c(0.1,0.2,
                       0.1,0.2,
                       0.1,0.2,
                       0.1,0.2,
                       0.1,0.2,
                       0.1,0.2,
                       0.1,0.2,
                       0.1,0.2,
                       0.1,0.2,
                       0.1,0.2),ncol = 2, byrow = TRUE)
# By default, individuals are simulated from uniform distribution
# and deltas are simulated randomly
sim1 <- simGDINA(N,Q,gs.parm = gs,model="DINA")
sim2 <- simGDINA(N,Q,gs.parm = gs,model=c(rep("DINA",9),"DINO"))
dat <- rbind(extract(sim1,"dat"),extract(sim2,"dat"))
gr <- c(rep("male",N),rep("female",N))
dif.out <- dif(dat,Q,group=gr)
plotIRF(dif.out,4)
dif.out2 <- dif(dat,Q,group=gr,method="LR")
}
}
\author{
{Wenchao Ma, Rutgers University, \email{wenchao.ma@rutgers.edu} \cr Jimmy de la Torre, The University of Hong Kong}
}
\references{
Hou, L., de la Torre, J., & Nandakumar, R. (2014). Differential item functioning assessment in cognitive diagnostic modeling: Application of the Wald test to
investigate DIF in the DINA model. \emph{Journal of Educational Measurement, 51}, 98-125.
}
\seealso{
\code{\link{GDINA}}
}

