% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monocheck.R
\name{monocheck}
\alias{monocheck}
\title{This function checks if monotonicity is violated}
\usage{
monocheck(object, strict = FALSE)
}
\arguments{
\item{object}{object of class \code{\link{GDINA}}}

\item{strict}{whether a strict monotonicity is checked?}
}
\value{
a logical vector for each item or category indicating whether
the monotonicity is violated (\code{TRUE}) or not (\code{FALSE})
}
\description{
If mastering an additional attribute lead to a lower probabilities of success,
the monotonicity is violated.
}
\examples{
\dontrun{
dat <- sim10GDINA$simdat
Q <- sim10GDINA$simQ


mod1 <- GDINA(dat = dat, Q = Q, model = "GDINA")
check <- monocheck(mod1)
check
mod2 <- GDINA(dat = dat, Q = Q, model = "GDINA",mono.constraint = check)
check2 <- monocheck(mod2)
check2
}
}

