% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotIRF.GDINA.R
\name{plotIRF}
\alias{plotIRF}
\title{Plot item success probability}
\usage{
plotIRF(object, item, errorbar = FALSE, ...)
}
\arguments{
\item{object}{model object of class \code{\link{GDINA}} or \code{\link{dif}}}

\item{item}{a vector specifying which item(s) the plots are drawn for}

\item{errorbar}{add error bar to the plot?}

\item{...}{additional arguments}
}
\description{
Create plots of item/category success probability for each latent group
}
\examples{
\dontrun{
dat <- sim10GDINA$simdat
Q <- sim10GDINA$simQ
mod1 <- GDINA(dat = dat, Q = Q, model = "GDINA")
#plot item response functions for item 10
plotIRF(mod1,10)
plotIRF(mod1,9, errorbar = TRUE)
}
}
\seealso{
\code{\link{GDINA}}, \code{\link{autoGDINA}}, \code{\link{dif}}
}
