% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{extract}
\alias{extract}
\title{extract elements from objects of various classes}
\usage{
extract(object, what, ...)
}
\arguments{
\item{object}{objects from class \code{GDINA},\code{itemfit}, \code{modelcomp}, \code{Qval} or \code{simGDINA}}

\item{what}{what to extract}

\item{...}{additional arguments}
}
\description{
A generic function to extract elements from objects of class \code{GDINA},
\code{itemfit}, \code{modelcomp}, \code{Qval} or \code{simGDINA}. This
page gives the elements that can be extracted from the class \code{GDINA}.
To see what can be extracted from \code{\link{itemfit}}, \code{\link{modelcomp}}, and
\code{\link{Qval}}, go to the corresponding function help page.

Objects which can be extracted from \code{GDINA} objects include:

\describe{
\item{AIC}{AIC}
  \item{att.prior}{attribute prior weights for calculating marginalized likelihood in the last EM iteration}
  \item{attributepattern}{all attribute patterns involved in the current calibration}
\item{BIC}{BIC}
\item{CAIC}{CAIC}
\item{catprob.cov}{covariance matrix of item probability parameter estimates; Need to specify \code{SE.type}}
\item{catprob.parm}{item parameter estimates}
\item{catprob.se}{standard error of item probability parameter estimates; Need to specify \code{SE.type}}
\item{convergence}{\code{TRUE} if the calibration is converged.}
\item{dat}{raw data}
\item{del.ind}{deleted observation number}
\item{delta.cov}{covariance matrix of delta parameter estimates; Need to specify \code{SE.type}}
\item{delta.parm}{delta parameter estimates}
\item{delta.se}{standard error of delta parameter estimates; Need to specify \code{SE.type}}
  \item{designmatrix}{A list of design matrices for each item/category}
  \item{deviance}{deviance, or negative two times observed marginal log likelihood}
  \item{discrim}{GDINA discrimination index}
\item{expectedCorrect}{expected # of examinees in each latent group answering item correctly}
\item{expectedTotal}{expected # of examinees in each latent group}
\item{higher.order}{higher-order model specifications}
\item{logLik}{observed marginal log likelihood}
\item{linkfunc}{link functions for each item}
\item{initial.catprob}{initial item category probability parameters}
\item{natt}{number of attributes}
\item{ncat}{number of categories}
\item{ngroup}{number of groups}
\item{nitem}{number of items}
\item{nitr}{number of EM iterations}
\item{nobs}{number of observations, or sample size}
\item{nLC}{number of latent classes}
  \item{prevalence}{prevalence of each attribute}
  \item{posterior.prob}{posterior weights for each latent class}
  \item{reduced.LG}{Reduced latent group for each item}
  \item{SABIC}{SABIC}
\item{sequential}{is a sequential model fitted?}
}
}
\examples{
\dontrun{
dat <- sim10GDINA$simdat
Q <- sim10GDINA$simQ
fit <- GDINA(dat = dat, Q = Q, model = "GDINA")
extract(fit,"discrim")
extract(fit,"designmatrix")
}

}
