% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix_aggregate.R
\name{matrix_aggregate}
\alias{matrix_aggregate}
\title{Aggregate Some Rows and Columns of a Matrix}
\usage{
matrix_aggregate(
  M,
  row.index = NULL,
  col.index = NULL,
  row.name = NULL,
  col.name = NULL
)
}
\arguments{
\item{M}{a numeric matrix without NA.}

\item{row.index}{a numeric vector or a list of numeric vectors indicating the index numbers of rows to be aggregated.
The default value is is NULL.}

\item{col.index}{a numeric vector or a list of numeric vectors indicating the index numbers of columns to be aggregated.
The default value is is NULL.}

\item{row.name}{a character vector or a list of character vectors indicating the names of rows to be aggregated.
The default value is NULL.
If row.index or col.index is not NULL, row.name and col.name will be ignored.}

\item{col.name}{a character vector or a list of character vectors indicating the names of columns to be aggregated.
The default value is NULL.}
}
\description{
Aggregate some rows and columns of a matrix to obtain a matrix with smaller dimensions.
This function can be used for aggregating some rows and columns of an input-output table.
}
\examples{
\donttest{
M <- matrix(1:16,4,4,TRUE)
colnames(M) <- paste0("c",1:4)
rownames(M) <- paste0("r",1:4)
addmargins(M)

M2 <- matrix_aggregate(M, list(c(1,3),c(2, 4)), 2:3)
addmargins(M2)

M3 <- matrix_aggregate(M, row.name = list(c("r1","r3"),c("r2","r4")), col.name = c("c2","c3"))
addmargins(M3)
}
}
