% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/envelopes2d.r
\name{global_envelope_test2d}
\alias{global_envelope_test2d}
\alias{GET.2d}
\title{2D global envelope test}
\usage{
global_envelope_test2d(image_sets, ...)
}
\arguments{
\item{image_sets}{An image set, i.e. a set of 2d functions (or a list of them).
See \code{\link{create_image_set}}.}

\item{...}{Additional parameters to be passed to \code{\link{global_envelope_test}}.}
}
\value{
An object of class "global_envelope2d" (and "list"),
which can be printed and plotted directly.

Essentially a data frame containing columns
\itemize{
\item r = a list of vectors of values of x- and y-coordinates at which the test was made
\item obs = the data function (matrix), if there is only one data function. Otherwise not existing.
\item lo = the lower envelope (matrix) based on the simulated functions
\item hi = the upper envelope (matrix) based on the simulated functions
\item central = the central curve, mean (default) or median of the test functions
T_i(r), i=2, ..., s+1. Used for visualization only.
}
Additionally, the return value has attributes \code{method}, \code{type}, \code{alternative},
\code{k_alpha}, \code{alpha}, \code{k}, \code{p} (and \code{p_interval} and \code{ties} if
type is \code{'rank'}) and \code{call}, see more detailed description in
\code{\link{global_envelope_test}}.
}
\description{
Provides global envelope tests based on 2D functions
}
\examples{
\donttest{
# Example of spatial point pattern residuals
#-------------------------------------------
if(require("spatstat", quietly=TRUE)) {
  data(cells)
  X <- cells
  # Fit the hard-core process
  model <- ppm(X, interaction=Hardcore())
  summary(model)
  HD <- 0.08168525 # Hard-core process
  # Choose a bandwitdh by Scott's rule of thumb
  ds <- bw.scott(X); ds
  # Calculate raw residuals of the fitted model
  u <- diagnose.ppm(model, type="raw", rbord = HD, which ="smooth",
                    sigma=ds, plot.it=FALSE)
  obs <- u$smooth$Z$v
  # Generate simulations from the hard-core null model
  nsim <- 499 # Number of simulations; increase for serious analysis!
  simulations <- NULL
  ext.factor <- max(X$window$xrange[2]-X$window$xrange[1],
                    X$window$yrange[2]-X$window$yrange[1]) / 10
  win.extend <- owin(c(X$window$xrange[1]-ext.factor, X$window$xrange[2]+ext.factor),
                     c(X$window$yrange[1]-ext.factor, X$window$yrange[2]+ext.factor))
  mod02 <- list(cif="hardcore", par=list(beta=exp(model$fitin$coefs[1]),hc=HD), w=win.extend)
  # starting point pattern in an extended window
  x.start <- runifpoint(X$n, win=win.extend)
  # simulations
  for(sss in 1:nsim){
    uppp <- rmh(model=mod02, start=list(x.start=x.start), control=list(p=1,nrep=1e5,nverb=5000))
    f <- uppp$x > X$window$xrange[1] & uppp$x < X$window$xrange[2] &
         uppp$y > X$window$yrange[1] & uppp$y < X$window$yrange[2]
    simulations[[sss]] <- ppp(uppp$x[f], uppp$y[f], window=X$window)
  }
  # Calculate the raw residuals for simulations
  sim <- array(0, c(u$smooth$Z$dim, nsim))
  for(i in 1:length(simulations)) {
    model=ppm(simulations[[i]],interaction=Hardcore(HD));
    u_sim <- diagnose.ppm(model, type="raw", rbord = HD, which ="smooth", sigma=ds, plot.it=FALSE)
    sim[,,i] <- u_sim$smooth$Z$v
    if((i \%\% 100)==0) cat(i, ' ')
  }
  # Constract the global envelope test for the (2D) raw residuals
  iset <- create_image_set(list(obs=obs, sim_m=sim))
  res <- global_envelope_test2d(iset, type="area")
  plot(res)
  plot(res, contours=FALSE) + ggplot2::scale_fill_gradient(low="black", high="white")
  plot(res, fixedscales=FALSE)
}}
}
\references{
Mrkvička, T., Soubeyrand, S., Myllymäki, M., Grabarnik, P. and Hahn, U. (2016). Monte Carlo testing in spatial statistics, with applications to spatial residuals. Spatial Statistics 18, Part A: 40--53. doi: 10.1016/j.spasta.2016.04.005

Myllymäki, M., Mrkvička, T., Grabarnik, P., Seijo, H. and Hahn, U. (2017). Global envelope tests for spatial point patterns. Journal of the Royal Statistical Society: Series B (Statistical Methodology), 79: 381–404. doi: 10.1111/rssb.12172

Mrkvička, T., Hahn, U. and Myllymäki, M. (2018). A one-way ANOVA test for functional data with graphical interpretation. arXiv:1612.03608 [stat.ME]
}
