% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appl_indeptest.r
\name{GET.qq}
\alias{GET.qq}
\title{Test of independence based on the smoothed Q-Q plot}
\usage{
GET.qq(
  X,
  ngrid = c(64, 64),
  nsim = 999,
  sigma = NULL,
  atoms.x = NULL,
  atoms.y = NULL,
  ...
)
}
\arguments{
\item{X}{A matrix with n rows and 2 columns. Each row contains
one bivariate observation.}

\item{ngrid}{Vector with two elements, giving the number of grid
points to be used in the test statistic for each of the two marginals.
The default is 64 in each marginal.}

\item{nsim}{The number of random permutations used.}

\item{sigma}{Standard deviation of the smoothing kernel to be 
used for smoothing the Q-Q plot when computing the test statistic.
If NULL, sensible default value is used based on the number of observations.}

\item{atoms.x}{Vector specifying atomic values in the first marginal. See Examples.}

\item{atoms.y}{Vector specifying atomic values in the second marginal. See Examples.}

\item{...}{Additional parameters to be passed to \code{\link{global_envelope_test}}.
In particularly, \code{alpha} specifies the nominal significance level of the test,
and \code{type} the type of the global envelope test.}
}
\description{
Permutation-based test of independence in a bivariate vector
using the smoothed Q-Q plot as the test statistic.
}
\details{
Permutation-based test of independence in a bivariate sample,
based on Q-Q representation and estimate of the intensity function
computed on a regular grid of \code{ngrid[1]} times \code{ngrid[2]} points.

If the observed data are the pairs \eqn{\{(X_1, Y_1), \ldots, (X_n, Y_n)\}}{{(X_1, Y_1), ..., (X_n, Y_n)}},
the permutations are obtained by randomly permuting the values
in the second marginal, i.e. \eqn{\{(X_1, Y_{\pi(1)}), \ldots, (X_n, Y_{\pi(n)})\}}{{(X_1, Y_{pi(1)}), ..., (X_n, Y_{pi(n)})}}.

The test itself is performed using the global envelope test in the chosen version.
}
\examples{
# Generate sample data
\donttest{data <- matrix(rnorm(n=200), ncol=2) \%*\% matrix(c(1,1,0,1), ncol=2)}
\dontshow{data <- matrix(rnorm(n=20), ncol=2) \%*\% matrix(c(1,1,0,1), ncol=2)}
plot(data)

# Compute the QQ test and plot the significant regions
\donttest{res <- GET.qq(data, ngrid=c(30,20), nsim=999)}
\dontshow{res <- GET.qq(data, ngrid=c(30,20), nsim=19)}
plot(res)
# Extract the p-value
attr(res,"p")

# With atoms, independent
data <- cbind(rnorm(n=100), sample(4, size=100, replace=TRUE))
plot(data)
\donttest{res <- GET.qq(data, nsim=999, atoms.y=c(1,2,3,4))}
\dontshow{res <- GET.qq(data, nsim=19, atoms.y=c(1,2,3,4))}
plot(res)

\donttest{
# With atoms, dependent
data <- cbind(sort(rnorm(n=100)), sort(sample(4, size=100, replace=TRUE)))
plot(data)
res <- GET.qq(data, nsim=999, atoms.y=c(1,2,3,4))
plot(res)
}

# Atoms in both variables
data <- cbind(rnorm(n=100), rnorm(n=100)) \%*\% matrix(c(1,1,0,1), ncol=2)
data[,1][data[,1]<=-1] <- -1
data[,2][data[,2]<=-0.5] <- -0.5
plot(data)

# Perform the test
\donttest{res <- GET.qq(data, nsim=999, atoms.x=c(-1), atoms.y=c(-0.5), sigma=NULL)}
\dontshow{res <- GET.qq(data, nsim=19, atoms.x=c(-1), atoms.y=c(-0.5), sigma=NULL)}
plot(res)
}
\references{
Dvořák, J. and Mrkvička, T. (2022). Graphical tests of independence for general distributions. Computational Statistics 37, 671--699.
}
