\name{g.analyse}
\alias{g.analyse}
\title{
function to analsyse meta-data generated by \link{g.getmeta} and \link{g.impute}
}
\description{
Analyses the output from other functions within the packages to generate a basic
descriptive summary for each accelerometer data file. Analyses include: Average 
acceleration per day, per measurement, L5M5 analyses (assessment of the five
hours with lowest acceleration and with highest acceleration)

}
\usage{
g.analyse(I, C, M, IMP, qlevels = c(), qwindow = c(0, 24), quantiletype = 7,
L5M5window = c(0, 24), M5L5res = 10, includedaycrit = 16, ilevels = c(),
winhr = 5, idloc = 1)
}

\arguments{
  \item{I}{
    the output from function \link{g.inspectfile}
  }
  \item{C}{
    the output from function \link{g.calibrate}
  }
  \item{M}{
    the output from function \link{g.getmeta}
}
  \item{IMP}{
    the output from function \link{g.impute}
}
  \item{qlevels}{
    array of percentiles for which value needs to be extracted. These need to
    be expressed as a fraction of 1, e.g. c(0.1, 0.5, 0.75). There is no limit
    to the number of percentiles. If left empty then percentiles will not be 
    extracted. Distribution will be derived from short epoch metric data, see \link{g.getmeta}.
  }
  \item{qwindow}{
  start and end time, in 24 hour clock hours, over which distribution in metric 
  values need to be extracted. Value = c(0,24) will consider all 24 hours.
  }
  \item{quantiletype}{
  type of quantile function to use (default recommended). For details, see 
  quantile function in STATS package
  }
  \item{L5M5window}{
    start and end time, in 24 hour clock hours, over which L5M5 needs to be
    calculated. The calculation is done based on the average day
  }
  \item{M5L5res}{
resoltion of L5 and M5 analysis in minutes (default: 10 minutes)
  }
  \item{includedaycrit}{
    minimum required number of valid hours in day specific analysis
    (NOTE: there is no minimum required number of hours per day in the summary
    of an entire measurement, every available hour is used to make the best possible
    inference on average metric value per week)
  }
  \item{ilevels}{
    Levels for acceleration value frequency distribution in mg, e.g. c(0,100,200)
    There is no constriction to the number of levels.
  }
  \item{winhr}{
    window size in hours of L5 and M5 analysis (dedault = 5 hours)
  }
  \item{idloc}{
    If value = 1 (default) the code assumes that ID number is stored in the
    obvious header field. If value = 2 the code use the character string preceding
    the character '_' in the filename as the ID number.
  }

}
\value{
\item{\code{summary}}{summary for the file that was analysed}
\item{\code{daysummary}}{summary per day for the file that was analysed}
}
\author{
Vincent T van Hees <vincent.van-hees@newcastle.ac.uk>
}