\name{R.separate.ridge}
\alias{R.separate.ridge}
\title{ Estimation of Partial Correlation Matrix Using p 
        Separate Ridge Regressions. }
\description{ The partial correlation matrix is estimated by p 
              separate ridge regressions with the parameters 
              selected by cross validation. }
\usage{ R.separate.ridge(x, fold, lambda, verbose = FALSE) }
\arguments{
  \item{x      }{ n x p data matrix; n is the # of samples and 
                  p is the # of variables. }
  \item{fold   }{ Ridge parameters are selected by fold-cross 
                  validations separately for each regression.}
  \item{lambda }{ The candidate ridge parameters for all p 
                  ridge regressions. }
  \item{verbose}{TRUE/FALSE; if TRUE, print the procedure. }
}
\value{
  \item{R         }{ The partial correlation matrix.}
  \item{lambda.sel}{ The selected tuning parameters for p 
                     ridge regressions.}
}
\references{
Ha, M. J. and Sun, W. 
(2014).
Partial correlation matrix estimation using ridge penalty followed 
by thresholding and re-estimation.
Biometrics, 70, 762--770.
}
\author{ Min Jin Ha }
\examples{
  p <- 100 # number of variables
  n <- 50 # sample size
	
  ###############################
  # Simulate data
  ###############################
  simulation <- simulateData(G = p, etaA = 0.02, n = n, r = 1)
  data <- simulation$data[[1L]]
  stddata <- scale(x = data, center = TRUE, scale = FALSE)
    
  ###############################
  # estimate ridge parameter
  ###############################
  w.upper <- which(upper.tri(diag(p)))

  lambda.array <- seq(from = 0.1, to = 20, by=0.1) * (n-1.0)
  partial.sep <-  R.separate.ridge(x = stddata,
                                   lambda = lambda.array,
                                   fold = 5L,
                                   verbose = TRUE)$R[w.upper]
}
