% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggmatrix_gtable.R
\name{ggmatrix_gtable}
\alias{ggmatrix_gtable}
\title{Print ggpair object}
\usage{
ggmatrix_gtable(pm, ..., progress = interactive() && (pm$ncol * pm$nrow) > 15,
  progress_format = " plot: [:plot_i,:plot_j] [:bar]:percent est::eta ")
}
\arguments{
\item{pm}{ggpair object to be plotted}

\item{...}{ignored}

\item{progress}{boolean to determine if a progress bar should be displayed. This defaults to interactive sessions only}

\item{progress_format}{string supplied directly to \code{progress::\link[progress]{progress_bar}(format = progress_format)}. Defaults to display the plot number, progress bar, percent complete, and estimated time to finish.}
}
\description{
Specialized method to print the ggpair object-
}
\examples{
data(tips, package = "reshape")
pm <- ggpairs(tips, c(1,3,2), mapping = ggplot2::aes_string(color = "sex"))
ggmatrix_gtable(pm)
}
\author{
Barret Schloerke \email{schloerke@gmail.com}
}

